SuperStrict

Import "gfx/blitz.o"
Import "include\Extern\simplexnoise.cpp"

Framework brl.GLMax2D

Import sidesign.MiniB3D

Import brl.tgaloader
Import brl.pngloader
Import brl.oggloader
Import brl.wavloader
Import brl.jpgloader

Import brl.Pixmap
Import brl.Random
Import brl.timer
Import brl.EventQueue
Import brl.DirectSoundAudio
Import brl.FreeTypeFont
Import brl.Map

Import bah.DBSQLite

Import maxgui.Drivers
Import maxgui.ProxyGadgets
Import maxgui.localization



' ------------------------------------------------------------------------------------------------
' Audio Driver
' ------------------------------------------------------------------------------------------------
?Win32
SetAudioDriver "directsound"
?MacOs
SetAudioDriver "freeaudio"
?



' ------------------------------------------------------------------------------------------------
' External C Sources
' ------------------------------------------------------------------------------------------------
Extern "C"

	Function octave_noise_2d:Float(octaves:Float, persistance:Float, Scale:Float, x:Float, y:Float)
	Function octave_noise_3d:Float(octaves:Float, persistance:Float, Scale:Float, x:Float, y:Float, z:Float)
	Function octave_noise_4d:Float(octaves:Float, persistence:Float, Scale:Float, x:Float, y:Float, z:Float, w:Float)
		
End Extern



' ------------------------------------------------------------------------------------------------
' Sourcecode Include
' ------------------------------------------------------------------------------------------------

Include "include\System\GUI.bmx"
Include "include\System\Init.bmx"
Include "include\System\Media.bmx"
Include "include\System\Objects.bmx"
Include "include\System\System.bmx"
Include "include\System\Variables.bmx"

Include "include\Functions\F3D.bmx"
Include "include\Functions\FBanks.bmx"
Include "include\Functions\FLog.bmx"
Include "include\Functions\FMath.bmx"
Include "include\Functions\FMouse.bmx"
Include "include\Functions\FNoise.bmx"
Include "include\Functions\FPixel.bmx"
Include "include\Functions\FPixmap.bmx"
Include "include\Functions\FQuaternion.bmx"
Include "include\Functions\FRandom.bmx"
Include "include\Functions\FText.bmx"
Include "include\Functions\FWin32.bmx"
Include "include\Functions\FWorld.bmx"

Include "include\Types\TAsteroid.bmx"
Include "include\Types\TBeat.bmx"
Include "include\Types\TCam.bmx"
Include "include\Types\TConfig.bmx"
Include "include\Types\TFlag.bmx"
Include "include\Types\TFPS.bmx"
Include "include\Types\TGradient.bmx"
Include "include\Types\TInfotext.bmx"
Include "include\Types\TLocale.bmx"
Include "include\Types\TMedia.bmx"
Include "include\Types\TMilkyway.bmx"
Include "include\Types\TMouse.bmx"
Include "include\Types\TPlanet.bmx"
Include "include\Types\TQuad.bmx"
Include "include\Types\TSimplex.bmx"
Include "include\Types\TSystem.bmx"
Include "include\Types\TTime.bmx"



' ------------------------------------------------------------------------------------------------
' Initialize
' ------------------------------------------------------------------------------------------------
AppTitle = PROJECT_TITLE

GLShareContexts()

SeedRnd 42

Global planets:Int = 10

Global seed:Int = RndSeed()

Global SEGMENTS:Int = 36
Global STARSCALE:Float = 1.0
Global STARVARIANCE:Float = 1.0

Global rs:Float = 0
Global rs1:Float = Rnd(360)
Global rs2:Float = Rnd(360)
Global maxdist:Float

Global olddist:Float
Global oldadd:Float
Global olddistcheck:Int = MilliSecs()
Global speed:Float
Global SUNOCCLUSION:TEntity
Global SUNOCCLUSIONOLD:TEntity
Global SUNOCCLUSIONCOUNTER:Float = 1.0
Global SUNOCCLUSIONCOUNTERDIRECTION:Int = 0
Global jetadd:Float
Global JETSPEED:Float

Global off:Float = 0.0

Global NEAREST:TSystemObject
Global NEARESTSCALE:Float
Global NEARESTAU:Float

'Global dummy:TMesh


' ------------------------------------------------------------------------------------------------
' Initialize Game
' ------------------------------------------------------------------------------------------------
InitGame()



' ------------------------------------------------------------------------------------------------
' Create Star Properties
' ------------------------------------------------------------------------------------------------
Global sysid:Int = 0
Global System:TSystem = New TSystem

System.Init
System.seed = 0


' ------------------------------------------------------------------------------------------------
' Star Color Editor
' ------------------------------------------------------------------------------------------------
Global KR:Int
Global KG:Int
Global KB:Int
Global KA1:Int
Global KA2:Int
Global StarColors:Int[]



' ------------------------------------------------------------------------------------------------
' Create Star Mesh and Glow
' ------------------------------------------------------------------------------------------------
Global StarPivot:TPivot = CreatePivot()
Global StarMesh:TMesh
Global StarDarken:TMesh
Global StarOuter1:TMesh
Global StarOuter2:TMesh
Global StarGlow1:TSprite
Global StarGlow2:TSprite
Global StarAtmo:TSprite

' Main Body
StarMesh = CreateCubeSphere(32, 1)
EntityParent StarMesh, StarPivot
PositionEntity StarMesh, 0, 0, 0
ScaleEntity StarMesh, 1, 1, 1
EntityFX StarMesh, 1

' Star Sprite #1
StarGlow1 = CreateSprite()
EntityTexture StarGlow1, MEDIA.GetTexture("STARGLOW1")
EntityFX StarGlow1, 1 + 16
EntityBlend StarGlow1, 3
EntityOrder StarGlow1, -1

' Star Sprite #2
StarGlow2 = CreateSprite()
EntityTexture StarGlow2, MEDIA.GetTexture("STARGLOW2")
EntityFX StarGlow2, 1 + 16
EntityBlend StarGlow2, 3
EntityOrder StarGlow2, -1

' Star Atmosphere Inner Glow
StarAtmo = CreateSprite()
EntityTexture StarAtmo, MEDIA.GetTexture("STARATMO")
EntityFX StarAtmo, 1 + 16
EntityBlend StarAtmo, 3
EntityOrder StarAtmo, -3
SpriteViewMode StarAtmo, 2



' ------------------------------------------------------------------------------------------------
' Star Cubemab Textures
' ------------------------------------------------------------------------------------------------
Local tex:TTexture[6]
Local pix:TPixmap[6]
Local bru:TBrush[6]
Local sur:TSurface[6]
Local x3d:Float, y3d:Float, z3d:Float
Local r:Int, g:Int, b:Int

NOISE.Scale = 1.0 / 128
NOISE.octaves = 5
NOISE.persistence = 0.9

RestoreData Star
GRADIENT.generate

For Local s:Int = 0 To CountSurfaces(StarMesh) - 1

	sur[s] = GetSurface(StarMesh, s + 1)
	bru[s] = CreateBrush()
	tex[s] = MEDIA.GetTexture("CUBEPIX" + s)
	pix[s] = tex[s].pixmap
	Local texsize:Int = MEDIA.GetTexture("CUBEPIX" + s).width
	
	For Local x:Int = 0 To texsize - 1
	
		For Local y:Int = 0 To texsize - 1
			
			Select s
			
				' Ymax
				Case 0
						x3d = x
						y3d = texsize - 1
						z3d = texsize - 1 - y
				
				' Zmin
				Case 1
						x3d = x
						y3d = texsize - 1 - y
						z3d = 0

				' Ymin
				Case 2
						x3d = x
						y3d = 0
						z3d = y

				' Xmin
				Case 3
						x3d = 0
						y3d = texsize - 1 - y
						z3d = texsize - 1 - x

				' Xmax
				Case 4
						x3d = texsize - 1
						y3d = texsize - 1 - y
						z3d = x
						
				' Zmax
				Case 5
						x3d = texsize - 1 - x
						y3d = texsize - 1 - y
						z3d = texsize - 1

			End Select
		
		
			Local c:Float = ((1 + NOISE.Noise3D(x3d, y3d, z3d)) * 127.5)
			
			r = GRADIENT.r[c]
			g = GRADIENT.g[c]
			b = GRADIENT.b[c]
						
			Local rgb:Int = CombineRGBA(r, g, b, 255)
			
			WritePixel(pix[s], x, y, rgb)
		
		Next
		
	Next
	
	BrushTexture bru[s], tex[s]
	TextureBlend tex[s], 5
	PaintSurface sur[s], bru[s]
	
	glBindTexture(GL_TEXTURE_2D, tex[s].gltex[0])
	glPixelStorei GL_UNPACK_ROW_LENGTH, pix[s].pitch / BytesPerPixel[pix[s].format]
	glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex[s].width, tex[s].Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pix[s].Pixels
	
Next



' ------------------------------------------------------------------------------------------------
' Star Detail Textures
' ------------------------------------------------------------------------------------------------
EntityTexture StarMesh, MEDIA.GetTexture("STARDETAIL1"), 0, 1
EntityTexture StarMesh, MEDIA.GetTexture("STARDETAIL2"), 0, 2
EntityTexture StarMesh, MEDIA.GetTexture("STARDETAIL3"), 0, 3

ScaleTexture MEDIA.GetTexture("STARDETAIL1"), 1.0 / 4, 1.0 / 4
ScaleTexture MEDIA.GetTexture("STARDETAIL2"), 1.0 / 8, 1.0 / 8
ScaleTexture MEDIA.GetTexture("STARDETAIL3"), 1.0 / 16, 1.0 / 16

TextureBlend MEDIA.GetTexture("STARDETAIL1"), 5
TextureBlend MEDIA.GetTexture("STARDETAIL2"), 5
TextureBlend MEDIA.GetTexture("STARDETAIL3"), 5

Local tex1:TTexture = MEDIA.GetTexture("STARDETAIL1")
Local pixmap1:TPixmap = tex1.pixmap

Local tex2:TTexture = MEDIA.GetTexture("STARDETAIL2")
Local pixmap2:TPixmap = tex2.pixmap

Local tex3:TTexture = MEDIA.GetTexture("STARDETAIL3")
Local pixmap3:TPixmap = tex3.pixmap
										
NOISE.Scale = 1.0
NOISE.octaves = 7
NOISE.persistence = 0.5

For Local x:Int = 0 To tex1.width - 1

	For Local y:Int = 0 To tex1.width - 1
																				
		Local c:Int = Limitint((1 + NOISE.Noise3D(x, y, off)) * 127.5, 144, 160)
		Local rgb:Int = CombineRGBA(c, c, c, 255)
		
		WritePixel(pixmap1, x, y, rgb)
		WritePixel(pixmap2, x, y, rgb)
		WritePixel(pixmap3, x, y, rgb)
																				
	Next

	off:+(1.0 * FPS.multi)
	
Next
										
glBindTexture(GL_TEXTURE_2D, tex1.gltex[0])
glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap1.pitch / BytesPerPixel[pixmap1.format]
glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex1.width, tex1.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap1.Pixels

glBindTexture(GL_TEXTURE_2D, tex2.gltex[0])
glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap2.pitch / BytesPerPixel[pixmap2.format]
glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex2.width, tex2.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap2.Pixels

glBindTexture(GL_TEXTURE_2D, tex3.gltex[0])
glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap3.pitch / BytesPerPixel[pixmap3.format]
glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex3.width, tex2.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap3.Pixels



' ------------------------------------------------------------------------------------------------
' Star Atmosphere Glows
' ------------------------------------------------------------------------------------------------
StarDarken = CreateGlow(StarPivot, 1.0, 1.0, SEGMENTS, 1 + 2 + 32, 1, 0, 0, 0, 0.5, 0, 0, 0, 0.0)
StarOuter1 = CreateGlow(StarPivot, 1.0, 1.0, SEGMENTS, 1 + 2 + 32, 3, 255, 255, 255, 1.0, 255, 255, 255, 0.0)
StarOuter2 = CreateGlow(StarPivot, 1.0, 1.0, SEGMENTS, 1 + 2 + 32, 3, 255, 255, 255, 1.0, 255, 255, 255, 0.0)
UpdateGlow(StarDarken, 0.99, 2.0, SEGMENTS)
UpdateGlow(StarOuter1, 0.99, 1.1, SEGMENTS)
UpdateGlow(StarOuter2, 0.99, 2.0, SEGMENTS)
EntityOrder StarDarken, 100



' ------------------------------------------------------------------------------------------------
' Zones
' ------------------------------------------------------------------------------------------------

' Habitable Zone
Global FroZone:TMesh
Global HabZone:TMesh
Global HotZone:TMesh

Global ZoneAlpha:Float = 1.0
Global ZoneSegments:Int = 360

HotZone = CreateGlow(Null, 0, 0, ZoneSegments, 1 + 2 + 16 + 32, 1, 255, 0, 0, ZoneAlpha, 255, 0, 0, 1)
HabZone = CreateGlow(Null, 0, 0, ZoneSegments, 1 + 2 + 16 + 32, 1, 255, 255, 0, ZoneAlpha, 0, 255, 0, 1)
FroZone = CreateGlow(Null, 0, 0, ZoneSegments, 1 + 2 + 16 + 32, 1, 0, 128, 255, ZoneAlpha, 0, 0, 255, 1)
EntityOrder HotZone, 400
EntityOrder HabZone, 500
EntityOrder FroZone, 600

EntityTexture HotZone, MEDIA.GetTexture("GRADHALF")
EntityTexture HabZone, MEDIA.GetTexture("GRADFULL")
EntityTexture FroZone, MEDIA.GetTexture("GRADHALF")



' ------------------------------------------------------------------------------------------------
' Initialize Star Surface Animation
' ------------------------------------------------------------------------------------------------
Global ms:Int = MilliSecs()

' prepare Animation Texture Strip
Global cols1:Int = 16
Global rows1:Int = 8
Global stripsize:Int = rows1 * cols1
ScaleTexture MEDIA.GetTexture("STARFLARE"), cols1, rows1
TextureBlend MEDIA.GetTexture("STARFLARE"), 5

' Create Surface Glow Mesh
Global glowmesh:TMesh = CreateMesh(starmesh)
Global glowsurf:TSurface = CreateSurface(glowmesh)
EntityTexture glowmesh, MEDIA.GetTexture("STARFLARE")
EntityBlend glowmesh, 3
EntityFX glowmesh, 1 + 2 + 16 + 32

' Create Border Flare Mesh
Global flaremesh:TMesh = CreateMesh(starpivot)
Global flaresurf:TSurface = CreateSurface(flaremesh)
EntityTexture flaremesh, MEDIA.GetTexture("STARFLARE")
EntityBlend flaremesh, 3
EntityFX flaremesh, 1 + 16
EntityAlpha flaremesh, 1
EntityOrder flaremesh, 1

' Create Border Flare Mesh
Global flareglowmesh:TMesh = CreateMesh(starmesh)
Global flareglowsurf:TSurface = CreateSurface(flareglowmesh)
EntityTexture flareglowmesh, MEDIA.GetTexture("STARGLOW3")
TextureBlend MEDIA.GetTexture("STARGLOW3"), 3
EntityBlend flareglowmesh, 3
EntityFX flareglowmesh, 1 + 2 + 16 + 32



' ------------------------------------------------------------------------------------------------
' White Star Matter Jets FX
' ------------------------------------------------------------------------------------------------
Global jetscale:Float = 512
Global jetfactor:Float = 8
Global jetpivot:TPivot = CreatePivot()
TextureBlend MEDIA.GetTexture("JETA"), 3
TextureBlend MEDIA.GetTexture("JETB"), 5

' Jet
Global jet:TMesh = CreateSphere(32, jetpivot)
ScaleEntity jet, jetscale / jetfactor, jetscale, jetscale / jetfactor
EntityTexture jet, MEDIA.GetTexture("JETA"), 0, 0
EntityTexture jet, MEDIA.GetTexture("JETALPHA"), 0, 1
EntityTexture jet, MEDIA.GetTexture("JETB"), 0, 2
EntityFX jet, 1 + 16'2 + 16 + 32
EntityBlend jet, 3
EntityColor jet, 64, 128, 255
FlipMesh jet

' Jet Disk
Global jetdisk:TMesh = Createring(jet, 30, 0, 1, 1 + 2 + 16, 0, 0, 255, 1)
EntityTexture jetdisk, MEDIA.GetTexture("JETC"), 0, 0
TextureCoords MEDIA.GetTexture("JETC"), 1
TextureBlend MEDIA.GetTexture("JETC"), 2
RotateMesh jetdisk, 90, 0, 0
EntityBlend jetdisk, 3
HideEntity jetdisk

' reset Jet coordinates
Local surf2:TSurface = GetSurface(jet, 1)
For Local v:Int = 0 To CountVertices(surf2) - 1

	Local vx:Float = VertexX(surf2, v)
	Local vy:Float = VertexY(surf2, v)
	Local vz:Float = VertexZ(surf2, v)
		
	vx = (vx * Abs(vy))
	vz = (vz * Abs(vy))

	VertexCoords surf2, v, vx, vy, vz
	VertexTexCoords(surf2, v, VertexU(surf2, v), Abs(vy))
	
	
Next

' Collision ends for Jet
Global jetend1:TMesh = Createquad()
EntityParent jetend1, jet
RotateMesh jetend1, -90, 0, 0
EntityFX jetend1, 1
EntityColor jetend1, 0, 255, 0
ScaleEntity jetend1, 1.0, 1.0 / jetfactor, 1.0
MoveEntity jetend1, 0, 10, 0
HideEntity jetend1

Global jetend2:TMesh = Createquad()
EntityParent jetend2, jet
RotateMesh jetend2, 90, 0, 0
EntityFX jetend2, 1
EntityColor jetend2, 0, 255, 0
ScaleEntity jetend2, 1.0, 1.0 / jetfactor, 1.0
MoveEntity jetend2, 0, -10, 0
HideEntity jetend2

' Collision check for Jet
Global jetcollider:TMesh = CreateSphere(16, camera.cam)
EntityPickMode jetcollider, 1



' ------------------------------------------------------------------------------------------------
' Icons
' ------------------------------------------------------------------------------------------------
Global gravitationsprite:TSprite = CreateSprite(camera.cam)
EntityTexture gravitationsprite, MEDIA.GetTexture("GRAVITATION")
EntityFX gravitationsprite, 1
EntityColor gravitationsprite, 255, 0, 0
EntityOrder gravitationsprite, -1

Global temperaturesprite:TSprite = CreateSprite(camera.cam)
EntityTexture temperaturesprite, MEDIA.GetTexture("TEMPERATURE")
EntityFX temperaturesprite, 1
EntityColor temperaturesprite, 255, 255, 0
EntityOrder temperaturesprite, -1

Global orbitsprite:TSprite = CreateSprite(camera.cam)
EntityTexture orbitsprite, MEDIA.GetTexture("ORBIT")
EntityFX orbitsprite, 1
EntityColor orbitsprite, 0, 255, 0
EntityOrder orbitsprite, -1

Global gamma:Int
Global gammahit:Int
Global gammasprite:TSprite = CreateSprite(camera.cam)
EntityTexture gammasprite, MEDIA.GetTexture("RADIOACTIVITY")
EntityFX gammasprite, 1
EntityColor gammasprite, 0, 128, 255
EntityOrder gammasprite, -1

Global jetsprite:TSprite = CreateSprite(camera.cam)
EntityTexture jetsprite, MEDIA.GetTexture("JET")
EntityFX jetsprite, 1
EntityColor jetsprite, 255, 0, 255
EntityOrder jetsprite, -1


' ------------------------------------------------------------------------------------------------
' Distribute Quads to Surface Glow and Border Flare
' ------------------------------------------------------------------------------------------------
Local quad:TQuad
Global glowlist:TList = CreateList()

For Local i:Int = 1 To 5000

	quad = New TQuad
		
	' 90% Surface Glow and 10% Border Flares
	quad.quadclass = 0
	If Rnd(1) > 0.9 Then quad.quadclass = 1
	If Rnd(1) > 0.99 Then quad.quadclass = 2
			
	' Surface Glow
	If quad.quadclass = 0 Then

		quad.mesh = glowmesh
		quad.surf = glowsurf
		quad.ani = Rand(0, stripsize)
		quad.anispeed = Rnd(0.5, 1.0)
		
	' Border Flare
	Else If quad.quadclass = 1 Then
				
		quad.mesh = flaremesh
		quad.surf = flaresurf
		quad.ani = Rand(0, stripsize)
		quad.anispeed = Rnd(0.5, 1.0)

	' Surface Glow Flares
	Else If quad.quadclass = 2

		quad.mesh = flareglowmesh
		quad.surf = flareglowsurf
		quad.ani = Rand(0, stripsize)
		quad.anispeed = Rnd(0.5, 1.0)
		
	EndIf
		
	quad.Add()
	ListAddLast(glowlist, quad)
	
Next



' ------------------------------------------------------------------------------------------------
' System Light
' ------------------------------------------------------------------------------------------------
Global light:TLight = CreateLight(2)
AmbientLight 32, 64, 128



' ------------------------------------------------------------------------------------------------
' System Planets Object
' ------------------------------------------------------------------------------------------------
Global systemlist:TList = CreateList()
Global planetlist:TList = CreateList()
Global systempivot:TPivot = CreatePivot()
Global s:TSystemObject

Type TSystemObject

	Field x:Float
	Field y:Float
	Field z:Float
	Field Scale:Float
	Field Scaler:Float
	Field AU:Float
	Field id:Int
	Field Name:String
	Field ent:TMesh
	
	Field toohot:Int
	
	Field orbit:TOrbit = New TOrbit
	
	Field lod:TSprite
	Field piv:TPivot
	Field speed:Float
	Field rotation:Float
	Field rotationspeed:Float
	Field imp:TSprite
	Field RGB:Int[]
	Field Alpha:Float
	Field dist:Float
	Field multi:Float
	Field factor:Float
	Field minsize:Float
	
	Field rot:Int
	
	Function Sort()
	
		SortList(planetlist, True, CompareDistance)
		
	End Function
	
	Function CompareDistance:Int(o1:Object, o2:Object)
	
		If TSystemObject(o1).dist > TSystemObject(o2).dist Return 1
		
		Return 0
		
	End Function

End Type

Type TOrbit

	Field steps:Double
	Field x:Double[1440 + 1]
	Field y:Double[1440 + 1]
	Field z:Double[1440 + 1]

End Type



' ------------------------------------------------------------------------------------------------
' Star
' ------------------------------------------------------------------------------------------------
s = New TSystemObject
s.id = 0
s.Name = "Star"
s.AU = 0
s.Scale = STARSCALE
s.ent = StarMesh
ListAddLast(systemlist, s)
ListAddLast(planetlist, s)



' ------------------------------------------------------------------------------------------------
' Planets
' ------------------------------------------------------------------------------------------------
For Local i:Int = 1 To planets

	s = New TSystemObject
	
	s.piv = CreatePivot(systempivot)
	s.ent = CreateSphere(64, s.piv)
		
	EntityPickMode s.ent, 1
	
	s.LOD = CreateSprite(s.ent)
	EntityTexture s.LOD, MEDIA.GetTexture("PLANETGLOW")
	EntityBlend s.LOD, 3
	ScaleSprite s.LOD, 1, 1
	
	s.RGB = [64, 64, 64]
	s.id = i
	s.Name = "Planet " + i
	
	EntityTexture s.ent, MEDIA.GetTexture("PLANET")
	TextureBlend MEDIA.GetTexture("PLANET"), 5
	UpdateMeshColor(s.ent, s.RGB[0], s.RGB[1], s.RGB[2])
	EntityColor s.ent, s.RGB[0], s.RGB[1], s.RGB[2]
	
	'If s.id = 1 Then dummy = CreateSphere(32, s.ent)
	'PositionEntity dummy, 0, 0, 0
	'RotateEntity dummy,Rnd(360),Rnd(360),Rnd(360)
	'MoveEntity dummy, 0, 0, 4
	'ScaleEntity dummy, 0.1, 0.1, 0.1
					
	ListAddLast(systemlist, s)
	ListAddLast(planetlist, s)
	
Next




' ------------------------------------------------------------------------------------------------
' Create a new System
' ------------------------------------------------------------------------------------------------
System.id = sysid
System.SetStar(sysid)
OtherSystem(sysid)
SystemTitle()
NewStarColor()
Draworbits()
UpdateStar()



' ------------------------------------------------------------------------------------------------
' Create Timers for System Info
' ------------------------------------------------------------------------------------------------
TITLE_BLIP = New TBeat.Create (40, DrawBlip)
TITLE_FADE = New TBeat.Create (6, FadeBlip)

rem


' ------------------------------------------------------------------------------------------------
' Bezier Path
' ------------------------------------------------------------------------------------------------
Global PointAdummy:TMesh = CreateCube(Camera.cam)
EntityFX PointAdummy, 1
EntityColor PointAdummy, 255, 0, 0
ScaleEntity PointAdummy, 0.25, 0.25, 0.25
PositionEntity PointAdummy, 0, 0, 0

Global PointBdummy:TMesh = CreateCube(Camera.cam)
EntityFX PointBdummy, 1
EntityColor PointBdummy, 255, 0, 0
ScaleEntity PointBdummy, 0.25, 0.25, 0.25

Global PointCdummy:TMesh = CreateCube()
EntityFX PointCdummy, 1
EntityColor PointCdummy, 0, 255, 0
ScaleEntity PointCdummy, 0.25, 0.25, 0.25

Global PointDdummy:TMesh = CreateCube()
EntityFX PointDdummy, 1
EntityColor PointDdummy, 0, 0, 255
ScaleEntity PointDdummy, 0.25, 0.25, 0.25

Global Beziermesh:TPivot = CreatePivot()
Global Bezier:TMesh[100]
For Local i:Int = 0 To 99

	Bezier[i] = CreateCube(Beziermesh)
	EntityColor Bezier[i], 255, 0, 255
	EntityFX Bezier[i], 1

Next

endrem

' ------------------------------------------------------------------------------------------------
' Main Loop
' ------------------------------------------------------------------------------------------------
Global initializing:Int = MilliSecs()
AddHook EmitEventHook, EventHook

While Not AppTerminate()

Wend

End



' ------------------------------------------------------------------------------------------------
' Update Game Logic
' ------------------------------------------------------------------------------------------------
Function MainLoop()
	
	' read current time
	TIMER_Timer = MilliSecs()

	' check if update is allowed
	If (TIMER_Timer > TIMER_Update + TIMER_Lasttimer) Then

		' calculate new timer interval		
		TIMER_Interval = TIMER_Timer - TIMER_Lasttimer

		If TIMER_Interval > TIMER_Safe Then

			' check for framedrops
			TIMER_Interval = TIMER_Safe
			FPS.framedrops:+1

		End If
		
		FPS.multi = GAME_SPEED * TIMER_Interval
		
		' Update Camera
		CAMERA.Move
		CAMERA.zoom = MouseWheel ^ 2
						
		CAMERA.Update()
		CAMERA.GetCameraPosition
		
		' Milkyway background holds position
		MILKYWAY.KeepPosition(CAMERA.CAM)
				
		' store last timer
		TIMER_Lasttimer = TIMER_Timer
			
	EndIf

End Function

' updates the planet distances
Function UpdateDistances(s:TSystemObject)

	For s = EachIn planetlist
	
		s.dist = EntityDistance(CAMERA.cam, s.ent)
		
	Next

End Function

' updates the planets atmospheres
Function GetNearest(s:TSystemobject)
	
	Local FLAG:Int = 0
		
	' sort list by nearest planet
	s.Sort()
	
	For s = EachIn planetlist
		
		' first planet = nearest planet
		If FLAG = 0 Then
						
			' set nearest variables
			NEAREST = s
			NEARESTDIST = s.dist
			NEARESTSCALE = s.Scale
			NEARESTNAME = s.Name
			NEARESTAU = s.au
			
			FLAG = 1

		EndIf

		If s.id > 0 Then
					
			' Planet body adaptive scaling
			'Local ss:Float = 1.0 / Sqr(s.dist)
			Local ss:Float = 50.0 / s.dist
			If ss > 1 Then ss = 1		
			
			' Planet LOD Sprite adaptive scaling
			ScaleSprite s.LOD, s.dist / 750.0 / CAMERA.zoom, s.dist / 750.0 / CAMERA.zoom
			EntityAlpha s.LOD, LimitFloat(Normalize(EntityDistance(CAMERA.cam, StarMesh), maxdist, maxdist * 5, 1, 0), 0, 1)
			
			
			'If s.id <> NEAREST.id Then ss = 1.0 / s.dist
			ScaleEntity s.ent, ss, ss, ss
			
			' planet movement speed (rotation)		
			Local dist:Float = (NEAREST.dist - NEAREST.Scale)
			's.speed = dist * 1.0 / s.id / s.au * FPS.Multi * 100
			's.speed = (planets + 1 - s.id) / s.au * 1000000 * (dist / 100000.0)
			
			s.speed = 1.0 / s.AU * dist * 0.5
			
			If s.speed < 0.01 Then s.speed = 0.000
			'If s.speed > 10.00 Then s.speed = 10.00
						
			'If s.piv Then Turn s.piv, 0, s.speed * fps.multi, 0
			
			'RotateEntity s.piv, EntityPitch(s.piv), EntityYaw(s.piv), EntityRoll(s.piv)
			

		EndIf

	Next
	
End Function



' ------------------------------------------------------------------------------------------------
' Events
' ------------------------------------------------------------------------------------------------
Function EventHook:Object(id:Int, Data:Object, Context:Object)

	Local Event:TEvent = TEvent(data)
	If Event = Null Then Return Event

	Select Event.id

		Case EVENT_WINDOWCLOSE
								End

		Case EVENT_APPTERMINATE
								End

		Case EVENT_TIMERTICK
								Select Event.Source
								
									Case SCREEN_TIMER
														RedrawGadget MAXGUI_CANVAS

								End Select
								
								

		Case EVENT_GADGETPAINT
								
								SetGraphics CanvasGraphics(MAXGUI_CANVAS)

								Cls

								UpdateScaler()

								MainLoop()

								FLAG.Check("MILKYWAY", MILKYWAY.PIVOT)
								FLAG.Check("MILKYWAY_PANORAMA", MILKYWAY.Panorama)
								FLAG.Check("MILKYWAY_STARDETAIL", MILKYWAY.StarDetail)
								FLAG.Check("MILKYWAY_DETAIL", MILKYWAY.Detail)
								FLAG.Check("MILKYWAY_FIXSTARS", MILKYWAY.Starsphere)
																		
								' wireframe mode
								Wireframe FLAG.Get("WIREFRAME")
								
								' Distance to Star
								Local dist:Float = EntityDistance(CAMERA.CAM, StarMesh) - STARSCALE
								EntityRadius jetcollider, Sqr(dist)

								' Timed Sun/Planet Occlusion check for Glow Transition FX and Sunray Animation FX
								If MilliSecs() > olddistcheck Then
								
									speed = olddist - dist
									olddistcheck = MilliSecs() + 100
									olddist = dist
									
									If SUNOCCLUSION Then SUNOCCLUSIONOLD = SUNOCCLUSION Else SUNOCCLUSIONOLD = Null
									
									' Sun Rays Animation FX
									rs:+1
									
									NOISE.Scale = 1.0 / 16
									NOISE.octaves = 7
									NOISE.persistence = 0.5
									
									rs1:+NOISE.Noise3D(rs, 0, 0) / 5.0
									rs2:+NOISE.Noise3D(0, rs, 0) / 5.0
																										
								End If
								
								' Update Planet Distances and get nearest Planet
								UpdateDistances(s)
								GetNearest(s)
								
								' Speed Multiplier
								PLAYER_SPEEDMULTIPLICATOR = (NEARESTDIST - NEARESTSCALE)
								If PLAYER_SPEEDMULTIPLICATOR < 0.1 Then PLAYER_SPEEDMULTIPLICATOR = 0.1
								If NEARESTDIST < 25 Then CAMERA.currentspeed:*0.999

								' Zones Alpha Transition
								ZoneAlpha = Normalize(Abs(CAMERA.y), -100, 100, -1, 1)
								UpdateGlowAlpha(HotZone, ZoneAlpha, 0.0)
								UpdateGlowAlpha(HabZone, ZoneAlpha, 0.0)
								UpdateGlowAlpha(FroZone, ZoneAlpha, 0.0)

								' Adaptive Lightrange
								LightRange light, dist * 3
								
								' Adaptive Camera Range
								CAMERA.RangeMin = Sqr(NEARESTDIST - NEARESTSCALE) / 100.0
								CAMERA.RangeMax = CAMERA.RangeMin * 100000
								If CAMERA.RangeMin < 0.01 Then CAMERA.RangeMin = 0.01
								If CAMERA.RangeMax < 100000 Then CAMERA.RangeMax = 100000
								
								' Adaptive Star Glow Scaling
								Local sg:Float = UpdateScale(CAMERA.cam, StarMesh, 1, STARSCALE)
								ScaleEntity StarDarken, sg, sg, sg
								ScaleEntity StarOuter1, sg, sg, sg
								ScaleEntity StarOuter2, sg, sg, sg
								
								' Adaptive Star Mesh Scaling
								Local ss:Float = STARSCALE
								If ss < dist / 1280.0 Then ss = dist / 1280.0
								ScaleEntity StarPivot, ss, ss, ss
								
								' Adaptive Star Glow Camera-based Alpha Blending and Sun Occlusion FX
								Local ds:Float = limitfloat(dist / 100.0, 0, 1.0) + UpdateBrightness(StarGlow1, camera.cam)
								EntityAlpha StarGlow1, ds
								EntityAlpha StarGlow2, ds
								
								' Star Atmosphere Scaling
								ScaleSprite StarAtmo, sg * STARSCALE * 1.065, sg * STARSCALE * 1.065
								EntityAlpha StarAtmo, 1
																																
								' Special Handling of White Dwarfs and Stars
								Local s1:Float = sg * 4 * STARSCALE * (1 + ds) * Camera.Zoom
								Local s2:Float = sg * 8 * STARSCALE * (1 + ds) * Camera.Zoom
								Local s3:Float = SUNOCCLUSIONCOUNTER
								
								EntityAlpha gravitationsprite, 0.1
								EntityAlpha temperaturesprite, 0.1
								EntityAlpha orbitsprite, 0.1
								EntityAlpha gammasprite, 0.1
								EntityAlpha jetsprite, 0.1

								PositionSprite(gravitationsprite, SCREEN_WIDTH - (128 * Scaler), (64 * Scaler), 128, 128, True)
								PositionSprite(temperaturesprite, SCREEN_WIDTH - (128 * Scaler), (192 * Scaler), 128, 128, True)
								PositionSprite(orbitsprite, SCREEN_WIDTH - (128 * Scaler), (320 * Scaler), 128, 128, True)
								PositionSprite(gammasprite, SCREEN_WIDTH - (128 * Scaler), (448 * Scaler), 128, 128, True)
								PositionSprite(jetsprite, SCREEN_WIDTH - (128 * Scaler), (576 * Scaler), 128, 128, True)
								
								If System.CalcEscapeVelocity(dist) > 2000 Then EntityAlpha gravitationsprite, 1
								If System.CalcTemperatureAt(dist) > 2500 Then EntityAlpha temperaturesprite, 1						
								If (1000 - PLAYER_SPEEDMULTIPLICATOR) / 10.0 > 50 Then EntityAlpha orbitsprite, 1
										
								gamma = False
								gammahit = False
								If 1.0 / dist * Exp(100.0 / System.PeakRadiation) * System.Luminance > 100 And System.SpectralType <> "W" Then gamma = True
														
								If System.SpectralType = "W" Then
								
									' check for gamma rays at pulsars
									Local jx1:Float = EntityX(jetend1, 1)
									Local jy1:Float = EntityY(jetend1, 1)
									Local jz1:Float = EntityZ(jetend1, 1)
								
									Local jx2:Float = EntityX(jetend2, 1)
									Local jy2:Float = EntityY(jetend2, 1)
									Local jz2:Float = EntityZ(jetend2, 1)
									
									If System.Dwarfmode > 0 And (LinePick(0, 0, 0, -jx1, -jy1, -jz1) Or LinePick(0, 0, 0, -jx2, -jy2, -jz2)) Then
									
										If PickedEntity() = jetcollider Then gammahit = True
									
									End If
									
									if 1.0 / dist * Exp(10.0 / System.PeakRadiation) * System.TemperatureEstimated > 100 Then gamma = True

									' Show White Dwarf Matterjet and Radioactive symbol
									If System.Dwarfmode > 0 Then ShowEntity jet Else HideEntity jet
									'If System.Dwarfmode > 0 And gamma Then EntityAlpha gammasprite, 1

									' Apply Special Texture to White Stars
									EntityTexture StarGlow1, MEDIA.GetTexture("STARGLOW4")
									EntityTexture StarGlow2, MEDIA.GetTexture("STARGLOW4")
									RotateSprite StarGlow1, 0
									RotateSprite StarGlow2, 0
									ScaleSprite StarGlow1, s1 * 2, s1 * 2
									ScaleSprite StarGlow2, s2 * 2, s2 * 2
									
									' rotate White Dwarf and Star Body
									TurnEntity jetpivot, 0, JETSPEED * FPS.multi, 0
									RotateEntity StarMesh, EntityPitch(jetpivot), EntityYaw(jetpivot), EntityRoll(jetpivot)

									' Point Sprites to Camera
									PointEntity StarGlow1, CAMERA.cam
									PointEntity StarGlow2, CAMERA.cam
																		
									jetadd:+(1.0 * FPS.multi)
									
									TurnEntity jetdisk, 0, -500 * FPS.Multi, 0
																		
									PositionTexture MEDIA.GetTexture("JETA"), Sqr(jetadd), jetadd
									PositionTexture MEDIA.GetTexture("JETB"), -Sqr(jetadd), jetadd * 0.5
																		
								
								Else
								
									' Hide White Dwarf Matterjet
									HideEntity jet

									' Apply Standard Texture to Normal Stars
									EntityTexture StarGlow1, MEDIA.GetTexture("STARGLOW1")
									EntityTexture StarGlow2, MEDIA.GetTexture("STARGLOW2")
									RotateSprite StarGlow1, rs1
									RotateSprite StarGlow2, rs2
									ScaleSprite StarGlow1, s1 / s3, s1 / s3
									ScaleSprite StarGlow2, s2 / s3, s2 / s3
											
									' rotate Star Body
									TurnEntity StarMesh, 0, dist / 50.0 * FPS.Multi, 0
									
								EndIf
								
								If gamma Then EntityAlpha gammasprite, 1
								If gammahit Then EntityAlpha jetsprite, 1
								
								' Starglow Rings points to camera
								PointEntity StarDarken, CAMERA.cam
								PointEntity StarOuter1, CAMERA.cam
								PointEntity StarOuter2, CAMERA.cam
								PointEntity StarAtmo, CAMERA.cam
								
								' Star Activitiy
								If MilliSecs() > ms Then
																
									' update Corona
									UpdateStarCorona(dist)
									
									NOISE.Scale = 1.0 / 4
									NOISE.octaves = 9
									NOISE.persistence = 0.9
									
									' Giants with less activity than standard Stars
									If System.Giant = 0 Then ms = MilliSecs() + 10 Else ms = MilliSecs() + 25
																	
									' update only of close to Star
									If dist < STARSCALE * 10 Then
								
										' prepare the three Detail LOD Textures
										Local tex1:TTexture = MEDIA.GetTexture("STARDETAIL1")
										Local pixmap1:TPixmap = tex1.pixmap

										Local tex2:TTexture = MEDIA.GetTexture("STARDETAIL2")
										Local pixmap2:TPixmap = tex2.pixmap

										Local tex3:TTexture = MEDIA.GetTexture("STARDETAIL3")
										Local pixmap3:TPixmap = tex3.pixmap
																				
										' process 1000 random pixels
										For Local i:Int = 1 To 1000
										
											Local x:Int = Rand(0, tex1.width - 1)
											Local y:Int = Rand(0, tex1.Height - 1)
																														
											Local c:Int = Limitint((1 + NOISE.Noise3D(x, y, off)) * 127.5, 144, 160)
											
											Local r:Int = c
											Local g:Int = c
											Local b:Int = c
											
											Local rgb:Int = CombineRGBA(r, g, b, 255)
											
											WritePixel(pixmap1, x, y, rgb)
											WritePixel(pixmap2, x, y, rgb)
											WritePixel(pixmap3, x, y, rgb)
																														
										Next
										
										' increase Z offset for animation
										off:+(1.0 * FPS.multi)

										' Update texture pixmaps																				
										glBindTexture(GL_TEXTURE_2D, tex1.gltex[0])
										glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap1.pitch / BytesPerPixel[pixmap1.format]
										glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex1.width, tex1.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap1.Pixels

										glBindTexture(GL_TEXTURE_2D, tex2.gltex[0])
										glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap2.pitch / BytesPerPixel[pixmap2.format]
										glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex2.width, tex2.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap2.Pixels

										glBindTexture(GL_TEXTURE_2D, tex3.gltex[0])
										glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap3.pitch / BytesPerPixel[pixmap3.format]
										glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA8, tex3.width, tex2.Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap3.Pixels
																						
									End If
								
								EndIf
																
								' Sun Occlusion FX
								If LinePick(CAMERA.x, CAMERA.y, CAMERA.z, -CAMERA.x, -CAMERA.y, -CAMERA.z) Then
								
									' get obscurer
									SUNOCCLUSION = PickedEntity()
									
									' reorder Glow Sprites
									EntityOrder StarMesh, 1
									EntityOrder StarGlow1, 0
									EntityOrder StarGlow2, 0
									EntityOrder StarAtmo, 0
									
								Else

									' reset Flag
									SUNOCCLUSION = Null
								
									' reorder Glow Sprites
									EntityOrder StarMesh, 0
									EntityOrder StarGlow1, -1
									EntityOrder StarGlow2, -2
									EntityOrder StarAtmo, -3
										
								EndIf
																		
								' Sun Occlusion direction logic
								If SUNOCCLUSION <> SUNOCCLUSIONOLD Then
									
									If SUNOCCLUSIONOLD Then
									
										SUNOCCLUSIONCOUNTERDIRECTION = -1
										
									Else
									
										SUNOCCLUSIONCOUNTERDIRECTION = 1
										
									EndIf
										
								End If
							
								' Sun Occlusion Animation counter
								If SUNOCCLUSIONCOUNTERDIRECTION = -1 And SUNOCCLUSIONCOUNTER > 1.0 Then SUNOCCLUSIONCOUNTER:-(2 * FPS.multi)
								If SUNOCCLUSIONCOUNTERDIRECTION = 1 And SUNOCCLUSIONCOUNTER < 1.5 Then SUNOCCLUSIONCOUNTER:+(2 * FPS.multi)
								
								' Limit Sun Occlusion to given boundaries
								If SUNOCCLUSIONCOUNTER < 1.0 Then SUNOCCLUSIONCOUNTER = 1.0
								If SUNOCCLUSIONCOUNTER > 1.5 Then SUNOCCLUSIONCOUNTER = 1.5
								
								' Engine Sound
								Local masslock:Float = 1000 - PLAYER_SPEEDMULTIPLICATOR
								If masslock < 0 Then masslock = 0
								Local ms:Float = masslock / 1000.0
								
								Local c1:Float = Normalize(Abs(CAMERA.currentspeed), 0, 1, 0.0, 1.0)
								Local c2:Float = Normalize(ms, 0, 1, 0.0, 1.0)
								Local c3:Float = Normalize((((masslock / 10.0)) / 100.0), 0, 1, 0.5, 0.125)
																	
								SetChannelVolume(CHANNEL_ENGINE1, c1)
								SetChannelRate(CHANNEL_ENGINE1, c2)
								SetChannelVolume(CHANNEL_ENGINE2, c1)
								SetChannelRate(CHANNEL_ENGINE2, c3)
								
								UpdateWorld
								RenderWorld
								
								' disable lights for orbits
								glDisable(GL_LIGHTING)
								glEnable(GL_DEPTH_TEST)
								
								glEnable(GL_COLOR_MATERIAL)
								glEnable(GL_LINE_STIPPLE)
								glBegin(GL_LINES)
								
								' Draw Orbits
								If FLAG.Get("ORBITS") Then
								
									Local a:Float = Limitfloat(Normalize(dist, maxdist, maxdist * 5, 0.33, 0), 0, 0.33)
									Draworbits(128, 192, 255, a, a)
									
								EndIf
								
								rem
								
								If FLAG.Get("PATH") Then
								
									ShowEntity PointAdummy
									ShowEntity PointAdummy
									ShowEntity PointAdummy
									ShowEntity PointAdummy
									ShowEntity Beziermesh
								
									Local d:Float=10
								
									Local cx:Float = 0'Camera.X
									Local cz:Float = (149.6 * 0.5) + STARSCALE'Camera.Z
									Local cy:Float = cz * 0.25 * -1'Camera.Y

									' Point B: half way ahead of camera
									PositionEntity PointBdummy, 0, 0, 0
									MoveEntity PointBdummy, 0, 0, NEARESTDIST / 2.0
									
									' Point C: between camera and target and moved sideways
									PositionEntity PointCdummy, cx, cy, cz
									PointEntity PointCdummy, NEAREST.ent
									MoveEntity PointCdummy, 0, 0, NEARESTDIST / 2
									TFormPoint NEARESTDIST, 0, 0, PointCdummy, Null
									PositionEntity PointCdummy, TFormedX(), TFormedY(), TFormedZ()
																		
									' Point D: in orbit around target
									PositionEntity PointDdummy, EntityX(NEAREST.ent, 1), EntityY(NEAREST.ent, 1), EntityZ(NEAREST.ent, 1)
									PointEntity PointDdummy, PointAdummy
									MoveEntity PointDdummy, -2, 0, 2
									
									Local PointA:Float[] = [EntityX(PointAdummy, 1), EntityY(PointAdummy, 1), EntityZ(PointAdummy, 1)]
									Local PointB:Float[] = [EntityX(PointBdummy, 1), EntityY(PointBdummy, 1), EntityZ(PointBdummy, 1)]
									Local PointC:Float[] = [EntityX(PointCdummy, 1), EntityY(PointCdummy, 1), EntityZ(PointCdummy, 1)]
									Local PointD:Float[] = [EntityX(PointDdummy, 1), EntityY(PointDdummy, 1), EntityZ(PointDdummy, 1)]
																										
									Line3D(PointA[0], PointA[1], PointA[2], PointB[0], PointB[1], PointB[2], 255, 0, 0, 1)
									Line3D(PointB[0], PointB[1], PointB[2], PointC[0], PointC[1], PointC[2], 255, 0, 0, 1)
									Line3D(PointC[0], PointC[1], PointC[2], PointD[0], PointD[1], PointD[2], 255, 0, 0, 1)
									
									Local x1:Float = PointA[0]
									Local y1:Float = PointA[1]
									Local z1:Float = PointA[2]

									Local x2:Float = PointB[0]
									Local y2:Float = PointB[1]
									Local z2:Float = PointB[2]
									
									Local x3:Float = PointC[0]
									Local y3:Float = PointC[1]
									Local z3:Float = PointC[2]
																	
									Local x4:Float = PointD[0]
									Local y4:Float = PointD[1]
									Local z4:Float = PointD[2]
									
									Local bx:Float[100]
									Local by:Float[100]
									Local bz:Float[100]
									
									For Local i:Int = 1 To 100 Step 1
									
										Local t:Float = i / 100.0

										bx[i] = x1 * (1 - t) ^ 3 + 3 * x2 * (1 - t) ^ 2 * t + 3 * x3 * (1 - t) * t ^ 2 + x4 * t ^ 3
										by[i] = y1 * (1 - t) ^ 3 + 3 * y2 * (1 - t) ^ 2 * t + 3 * y3 * (1 - t) * t ^ 2 + y4 * t ^ 3
										bz[i] = z1 * (1 - t) ^ 3 + 3 * z2 * (1 - t) ^ 2 * t + 3 * z3 * (1 - t) * t ^ 2 + z4 * t ^ 3
										
										PositionEntity Bezier[i - 1], bx[i], by[i], bz[i]
										
										Local s:Float = EntityDistance(Bezier[i - 1], PointAdummy) / 1000.0
										
										ScaleEntity Bezier[i - 1], s, s, s
										
										'Line3D(x4, y4, z4, bx[i], by[i], bz[i], 255, 255, 0, 1)
										
									Next
									
								Else
								
									HideEntity PointAdummy
									HideEntity PointAdummy
									HideEntity PointAdummy
									HideEntity PointAdummy
									HideEntity Beziermesh
																	
								End If
								
								endrem

								glEnd()
								glDisable(GL_COLOR_MATERIAL)
								glEnable(GL_LIGHTING)
								glDisable(GL_DEPTH_TEST)

								' Adaptive Scaling of Milkyway background stars and detail texture
								ScaleTexture MILKYWAY.StarsTexture, 1.0 / (32 * CAMERA.zoom), 1.0 / (8 * CAMERA.zoom)
								ScaleTexture MILKYWAY.DetailTexture, 1.0 / (8 * Sqr(CAMERA.zoom)), 1.0 / (2 * Sqr(CAMERA.zoom))

								' Draw Zones
								FLAG.Check("ZONES", HotZone)
								FLAG.Check("ZONES", HabZone)
								FLAG.Check("ZONES", FroZone)
								
								' show/hide Starglow on demand
								FLAG.Check("GLOW", StarGlow1)
								FLAG.Check("GLOW", StarGlow2)
								
								' calculate FPS
								FPS.Update()

								' 2D GUI output
								GUI()

								' Bufferflip
								Flip FLAG.Get("VSYNC")

								' Memory Garbage Collection
								GCCollect()
								
								' let the OS breathe
								Delay FLAG.Get("DELAY")

		Case EVENT_KEYDOWN
								
								Select Event.Data
								
									' Milkyway
									Case KEY_F1
													FLAG.Switch("MILKYWAY")
									Case KEY_F2
													FLAG.Switch("MILKYWAY_PANORAMA")
									Case KEY_F3
													FLAG.Switch("MILKYWAY_STARDETAIL")
									Case KEY_F4
													FLAG.Switch("MILKYWAY_DETAIL")
									Case KEY_F5
													FLAG.Switch("MILKYWAY_FIXSTARS")
								
									' Player Movement
									Case KEY_W
													PlayerZSpeed = 1
									Case KEY_S
													PlayerZSpeed = -1
									Case KEY_A
													PlayerXSpeed = 1
									Case KEY_D
													PlayerXSpeed = -1
									Case KEY_R
													PlayerYSpeed = 1
									Case KEY_F
													PlayerYSpeed = -1
									Case KEY_X
													PlayerBrake = 1
													PlayerZSpeed = 0
													PlayerYSpeed = 0
													PlayerXSpeed = 0
													
									Case KEY_LSHIFT
													PlayerTurbo = 1

									' Resolution
									Case KEY_1
													SetResolution(1024, 768)

									Case KEY_2
													SetResolution(1280, 800)

									Case KEY_3
													SetResolution(1366, 768)

									Case KEY_4
													SetResolution(1920, 1080)

									Case KEY_5
													SetResolution(SCREEN_DESKTOPWIDTH, SCREEN_DESKTOPHEIGHT)

									
									' System
									Case KEY_ESCAPE
													End
													
									Case KEY_TAB
													FLAG.Switch("WIREFRAME")
													
									Case KEY_SPACE
													Repeat
													
														sysid:+1
														sysid = sysid Mod 65536
														System.id = sysid
														OtherSystem(sysid)
													
													Until System.Radius * 1.0 / System.SunRadiusKM > 100 Or System.SunMasses > 50
													
													System.SetStar(sysid)
													SystemTitle()
													NewStarColor()
													UpdateStar()

									Case KEY_N
													Repeat
													
														sysid:+1
														sysid = sysid Mod 65536
														System.id = sysid
														OtherSystem(sysid)
													
													Until System.SpectralType = "W"
													
													System.SetStar(sysid)
													SystemTitle()
													NewStarColor()
													UpdateStar()


									Case KEY_ENTER
													SystemTitle()
													
									Case KEY_NUMSUBTRACT
													Screenshot()
																										
									Case KEY_INSERT
													KR = LimitInt(KR + 4, 0, 256)
									Case KEY_DELETE
													KR = LimitInt(KR - 4, 0, 256)
									Case KEY_HOME
													KG = LimitInt(KG + 4, 0, 256)
									Case KEY_END
													KG = LimitInt(KG - 4, 0, 256)
									Case KEY_PAGEUP
													KB = LimitInt(KB + 4, 0, 256)
									Case KEY_PAGEDOWN
													KB = LimitInt(KB - 4, 0, 256)
									Case KEY_UP
													KA1 = KA1 + 16
									Case KEY_DOWN
													KA1 = KA1 - 16
									Case KEY_LEFT
													KA2 = KA2 - 16
									Case KEY_RIGHT
													KA2 = KA2 + 16

									' Flags
									Case KEY_V
													FLAG.Switch("VSYNC")
													FPS.averagefps = 0

									'Case KEY_F
									'				FLAG.Switch("FONT")

									Case KEY_G
													FLAG.Switch("GLOW")

									Case KEY_O
													FLAG.Switch("ORBITS")

									Case KEY_Z
													FLAG.Switch("ZONES")

									Case KEY_I
													FLAG.Switch("GUI")

									Case KEY_T
													FLAG.Switch("TITLE")
													
									Case KEY_P
													FLAG.Switch("PLANETS")

									Case KEY_F12
													FLAG.Switch("FPS")

									Case KEY_CFLEX
													FLAG.Switch("DELAY")

									Case KEY_BACKSPACE
													FLAG.Switch("PATH")

									Case KEY_L
													FLAG.Switch("NUKE")
													
								End Select

		Case EVENT_KEYUP
		
								Select Event.Data
								
									' Player Movement
									Case KEY_W
													PlayerZSpeed = 0
													
									Case KEY_S
													PlayerZSpeed = 0
													
									Case KEY_A
													PlayerXSpeed = 0
													
									Case KEY_D
													PlayerXSpeed = 0

									Case KEY_R
													PlayerYSpeed = 0
													
									Case KEY_F
													PlayerYSpeed = 0
													
									Case KEY_X
													PlayerBrake = 0
													
									Case KEY_LSHIFT
													PlayerTurbo = 0
													
								End Select
								
		Case EVENT_MOUSEDOWN							
								MouseButton = Event.Data
								
								Select Event.Data
								
									Case 1, 3
														
												sysid:+1
												sysid = sysid Mod 65536
												
												System.id = sysid
												System.SetStar(sysid)
												OtherSystem(sysid)
												SystemTitle()
												NewStarColor()
												UpdateStar()
												
									Case 2
												
												sysid:-1
												If sysid < 0 Then sysid = 0
												System.id = sysid
												System.SetStar(sysid)
												OtherSystem(sysid)
												SystemTitle()
												NewStarColor()
												UpdateStar()
												
								End Select
		
		Case EVENT_MOUSEUP
								MouseButton = 0
		
								Select Event.Data
								
									Case 1, 3
												
									Case 2
									
								End Select
								
		Case EVENT_MOUSEWHEEL
						
								If Event.Data > 0 Then

									MouseWheel:+1
									If MouseWheel > 5 Then MouseWheel = 5

								Else

									MouseWheel:-1
									If MouseWheel < 1 Then MouseWheel = 1

								EndIf
																

		Case EVENT_MOUSEMOVE
								CAMERA.MX = Event.x
								CAMERA.MY = Event.y

	End Select
	
End Function



' ----------------------------------------------------------------------------
' changes brightness of star according to camera view angle
' ----------------------------------------------------------------------------
Function UpdateBrightness:Float(ent:TSprite, cam:TCamera, v:Float = 1.0, Size:Float = 1.0, scaling:Int = False)
	
	Local sx:Float, sy:Float, sz:Float
	Local a:Float
	Local x:Float, y:Float
	
	Local dist:Float = EntityDistance(CAMERA.CAM, StarMesh) - STARSCALE
		
	' get sun quad position in 3D space
	sx=EntityX(ent,1)
	sy=EntityY(ent,1)
	sz=EntityZ(ent,1)
	
	TFormPoint sx, sy, sz, Null, cam
	
	If TFormedZ() > 0 Then
	
		' calculate 2D position of sun quad
		CameraProject cam, sx, sy, sz
		x = Normalize(ProjectedX(), 0, SCREEN_WIDTH - v, -v, v)
		y = Normalize(ProjectedY(), 0, SCREEN_HEIGHT - v, -v, v)

		If x < - 1 Then x = -1
		If y < - 1 Then y = -1
		If x > 1 Then x = 1
		If y > 1 Then y = 1

		a = ((v - Abs(x)) * (v - Abs(y))) * (1 - (1.0 / dist))
				
	EndIf

	Return LimitFloat(a, 0, 1)
				
End Function



' ------------------------------------------------------------------------------------------------
' Update Star Corona Animation
' ------------------------------------------------------------------------------------------------
Function UpdateStarCorona(dist:Float, Init:Int = False)

	Local r:Int = limitint(Starcolors[0] * Rnd(0.9, 1.1), 0, 255)
	Local g:Int = limitint(Starcolors[1] * Rnd(0.9, 1.1), 0, 255)
	Local b:Int = limitint(Starcolors[2] * Rnd(0.9, 1.1), 0, 255)

	Local f:String = "Screen"
	Local r1:Int = Filter(r, 128, f)
	Local g1:Int = Filter(g, 128, f)
	Local b1:Int = Filter(b, 128, f)

	For Local quad:TQuad = EachIn glowlist

		If Init Then quad.ani = Rand(0, stripsize)
		quad.ani:+quad.anispeed
				
		Local recycle:Int = False
		If Int(quad.ani) >= stripsize And quad.quadclass <> 2 Then recycle = True
						
		If recycle Or Init Then
		
			quad.x = Rnd(-100, 100)
			quad.y = Rnd(-100, 100)
			quad.z = Rnd(-100, 100)
							
			TFormNormal quad.x, quad.y, quad.z, Null, Null
			
			' reset animation start
			If (Not Init) Then quad.ani = 0
																
			quad.RGB = [r, g, b]
			
			Local tf:Float = (1.0 + CAMERA.RangeMin)
			If tf > 1.001 Then tf = 1.001

						
			' bubbles
			If quad.quadclass = 0 Then
			
				quad.anispeed = Rnd(0.5, 1.0)
			
				Local mx:Float = 0.2
				If System.Giant = True Then mx = 0.4

				Local sc:Float = Rnd(0.025, Rnd(0.05, Rnd(0.1, mx)))
				quad.scalex = sc
				quad.scaley = sc
																
				quad.Alpha = Rnd(0.0625, 0.125)
			
				quad.x = TFormedX() * tf
				quad.y = TFormedY() * tf
				quad.z = TFormedZ() * tf
			
				' surface activity
				quad.AlignToTarget(quad.x, quad.y, quad.z, Rnd(360), 1)

			' flares
			Else If quad.quadclass = 1 Then
			
				quad.anispeed = Rnd(0.5, 1.0)

				Local mx:Float = 0.05
				If System.Giant = True Then mx = 0.4

				Local sc:Float = Rnd(0.02, Rnd(0.04, Rnd(0.08, mx)))
				
				If Rnd(1) > 0.99 Then sc:*2
				
				quad.scalex = sc
				quad.scaley = sc
				
				quad.Alpha = 1'Rnd(0, 1)
				If System.SpectralType = "W" Then quad.Alpha = 0 ; quad.scalex=0 ; quad.scaley=0
				
				quad.x = TFormedX() * tf
				quad.y = TFormedY() * tf
				quad.z = TFormedZ() * tf
				
				' flare activity
				Local s:Float = 0.75
				quad.AlignToTarget(quad.x * s, quad.y * s, quad.z * s, sc * 30, 1)
			
			Else
			
				quad.anispeed = Rnd(0.5, 1.0)
			
				Local sc:Float = Rnd(0.001, 0.25)
				quad.scalex = sc
				quad.scaley = sc
																
				quad.Alpha = Rnd(0.1, 0.25)
								
				quad.RGB = [255, 255, 255]
			
				quad.x = TFormedX() * tf
				quad.y = TFormedY() * tf
				quad.z = TFormedZ() * tf
			
				' surface activity
				quad.AlignToTarget(quad.x, quad.y, quad.z, Rnd(360), 1)

			EndIf

		EndIf
				
		Local row:Int = Int(quad.ani) / cols1
		Local col:Int = Int(quad.ani) - (row * cols1)
					
		If quad.quadclass = 1 Then quad.Update(CAMERA.cam)
			
		If quad.quadclass = 2 Then
		
			row = 0
			col = 0
			
		End If
		
		' Texture Animation
		quad.UpdateAnimation(row, col)
	
	Next

	CalculateStarColor()
									
	r = StarColors[0] * STARVARIANCE
	g = StarColors[1] * STARVARIANCE
	b = StarColors[2] * STARVARIANCE
	
	r1 = FloatMax(r * 8 * System.LuminanceClass, 192)
	g1 = FloatMax(g * 8 * System.LuminanceClass, 192)
	b1 = FloatMax(b * 8 * System.LuminanceClass, 192)

	EntityColor StarMesh, r * 2, g * 2, b * 2
	EntityColor StarGlow1, r1, g1, b1
	EntityColor StarGlow2, r, g, b
	EntityColor StarAtmo, r * 2, g * 2, b * 2
	
	Local fi:String = "Overlay"
	
	r1 = Filter(r * 4, 128, fi)
	g1 = Filter(g * 4, 128, fi)
	b1 = Filter(b * 4, 128, fi)
		
	LightColor light, r1, g1, b1

End Function



' ----------------------------------------------------------------------------
' Draw Planet orbits
' ----------------------------------------------------------------------------
Function Draworbits(r:Int = 0, g:Int = 128, b:Int = 255, a:Float = 0.5, factor:Float = 1.0)
		
	Local x1:Float, y1:Float, z1:Float
	Local x2:Float, y2:Float, z2:Float
		
	For Local s:TSystemObject = EachIn planetlist
					
		For Local i:Int = 0 To s.orbit.steps - 1
									
			Local p1:Int = i
			Local p2:Int = (p1 + 1) Mod s.orbit.steps
												
			x1 = s.orbit.x[p1]
			y1 = s.orbit.y[p1]
			z1 = s.orbit.z[p1]
						
			x2 = s.orbit.x[p2]
			y2 = s.orbit.y[p2]
			z2 = s.orbit.z[p2]
						
			Line3D(x1, y1, z1, x2, y2, z2, r, g, b, a)
							
		Next
		
	Next
					
End Function



' ----------------------------------------------------------------------------
' Create a new random system
' ----------------------------------------------------------------------------
Function OtherSystem(id:Int, giant:Int = 0)
	
	System.id = id
	System.NewRandomSystem
	If giant Then System.Giant = 1
	System.CalcSystem
																													
End Function



' ----------------------------------------------------------------------------
' Output System Title
' ----------------------------------------------------------------------------
Function SystemTitle()

	TITLE_DIGITS = 0
	TITLE_ALPHA = 1.0
	TITLE_OUTPUT = ""
	TITLE_TEXT = System.Title + ", Sector " + Spaces(sysid, 4, "0") + "~n" + System.Spectralclass + "~n" + FormatMath(System.SurfaceTemperature, 0) + " Kelvin~n" + FormatMath(System.Radius, 0) + " km" + "~n" + FormatMath(System.Age, 0) + " " + LOCALE.Get("SOLAR_YEARS")
	TITLE_TIMER:Int = MilliSecs() + (Len(TITLE_TEXT) * 90)

End Function



' ----------------------------------------------------------------------------
' Calculate a new Star Color
' ----------------------------------------------------------------------------
Function NewStarColor()

	Local r:Int, g:Int, b:Int, a1:Int, a2:Int

	Select System.SpectralType
		
		Case "W" r = 064 ; g = 128 ; b = 192 ; a1 = 255 ; a2 = 128
		Case "O" r = 016 ; g = 040 ; b = 255 ; a1 = 000 ; a2 = 512
		Case "B" r = 024 ; g = 040 ; b = 064 ; a1 = 064 ; a2 = 384
		Case "A" r = 052 ; g = 056 ; b = 060 ; a1 = 000 ; a2 = 512
		Case "F" r = 068 ; g = 056 ; b = 044 ; a1 = 000 ; a2 = 512
		Case "G" r = 076 ; g = 048 ; b = 024 ; a1 = 000 ; a2 = 640
		Case "K" r = 064 ; g = 028 ; b = 008 ; a1 = 064 ; a2 = 192
		Case "M" r = 128 ; g = 024 ; b = 016 ; a1 = 128 ; a2 = 192
		
	End Select
	
	KR = r
	KG = g
	KB = b
	KA1 = a1
	KA2 = a2
	
	StarColors = [r, g, b, KA1, KA2]

End Function



' ------------------------------------------------------------------------------------------------
' Calculate Star Colors and Alpha according to System.SpectralType definition
' ------------------------------------------------------------------------------------------------
Function CalculateStarColor()

	Local r:Int, g:Int, b:Int, a1:Int, a2:Int

	Select System.SpectralType
		
		Case "W" r = 064 ; g = 128 ; b = 192 ; a1 = 255 ; a2 = 128
		Case "O" r = 016 ; g = 040 ; b = 255 ; a1 = 000 ; a2 = 512
		Case "B" r = 024 ; g = 040 ; b = 064 ; a1 = 064 ; a2 = 384
		Case "A" r = 052 ; g = 056 ; b = 060 ; a1 = 000 ; a2 = 512
		Case "F" r = 068 ; g = 056 ; b = 044 ; a1 = 000 ; a2 = 512
		Case "G" r = 076 ; g = 048 ; b = 024 ; a1 = 000 ; a2 = 640
		Case "K" r = 064 ; g = 028 ; b = 008 ; a1 = 064 ; a2 = 192
		Case "M" r = 128 ; g = 024 ; b = 016 ; a1 = 128 ; a2 = 192
		
	End Select
	
	r = KR
	g = KG
	b = KB
	a1 = KA1
	a2 = KA2

	StarColors = [r, g, b, KA1, KA2]

	Local f1:Float = a1 / 255.0
	Local f2:Float = a2 / 255.0
				
	UpdateGlowColor(StarOuter1, r * (1 + f1), g * (1 + f1), b * (1 + f1), f1, r, g, b, 0)
	UpdateGlowColor(StarOuter2, r * (1 + f2), g * (1 + f2), b * (1 + f2), f2, r, g, b, 0)
	
End Function



' ------------------------------------------------------------------------------------------------
' Color Star according to spectral class
' ------------------------------------------------------------------------------------------------
Function UpdateStar(alpha1:Float = 1.0, alpha2:Float = 1.0)

	Local ss:Float = Log(System.SunRadii)
	If ss < 1 Then ss = 1

	' Update Star Scale
	STARSCALE = Sqr(System.Radius) / 1000.0 * Log10(Sqr(System.Radius))
	ScaleEntity StarPivot, STARSCALE, STARSCALE, STARSCALE
		
	' position player
	CAMERA.x = 0
	CAMERA.Z = ((149.6 * 0.5) + STARSCALE)' * -1
	CAMERA.Y = CAMERA.Z * 0.25 * -1
	CAMERA.updateposition
	PointEntity CAMERA.cam, StarMesh
	
	' randomize White Dwarf Jet Streams
	RotateEntity jet, System.JetRotation[0], 0, System.JetRotation[0]
	JETSPEED = System.JETSPEED
	
	Local dist:Float = EntityDistance(CAMERA.CAM, StarMesh) - STARSCALE
	
	planetlist = Null
	planetlist = CreateList()
	
	' Modern Art :-)
	'RotateEntity systempivot,Rnd(360), Rnd(360), Rnd(360)
	'Turn systempivot, Rnd(360), Rnd(360), Rnd(360)
	
	For Local s:TSystemObject = EachIn systemlist
	
		' planet mass effect
		If s.id > 0 Then

			s.Scale = 1's.id
			s.au = s.id * 50 * ss'TitiusBode(s.id) * 149.6 * ss

			s.toohot = False
			If System.CalcTemperatureAt(s.au) > 2000 Then s.toohot = True
			
			If (Not s.toohot) Then
			
				ListAddLast(planetlist, s)
	
				
				' pick radius for Sun Occlusion FX
				EntityRadius s.ent, s.Scale
				
				' planet orbit position
				s.rotation = System.sysRnd(0, 360, sysid + s.id)
							
				' calculate maximum scale of star system
				If Abs(s.au) > maxdist Then maxdist = Abs(s.au)
		
				' pivot initial rotation
				RotateEntity s.piv, 0, 0, 0
				
				Local r1:Float = 0.0
				Local r2:Float = 0.0
				
				'rem
				
				If System.SysRnd(0, 1, sysid + s.id) > 0.9 Or System.SpectralType = "W" Then
	
					r1 = System.sysrnd(-22.5, 22.5, sysid + s.id)
					r2 = System.sysrnd(-22.5, 22.5, sysid + s.id + 1)
										
				EndIf
				
				'endrem
	
				'Turn s.piv, r1, s.rotation, r2
				
				Turn s.piv, r1, s.rotation, r2
		
				' position planet
				PositionEntity s.ent, 0, 0, 0
				MoveEntity s.ent, 0, 0, s.au			
							
				s.orbit.steps = 1440 / (planets + 1 - s.id)
				'If s.orbit.steps < 360 Then s.orbit.steps = 360
							
				For Local i:Int = 0 To s.orbit.steps
				
					s.orbit.x[i] = EntityX(s.ent, 1)
					s.orbit.y[i] = EntityY(s.ent, 1)
					s.orbit.z[i] = EntityZ(s.ent, 1)
					
					Turn s.piv, 0, 360.0 / s.orbit.steps, 0
					
				Next
				
				ShowEntity s.piv
				
			Else
			
				HideEntity s.piv
				
			EndIf
			
						
		' solar Mass Effect
		Else

			ListAddLast(planetlist, s)
			s.Scale = STARSCALE * 1.1
			
		EndIf

	Next

	' calculate new Star Color
	CalculateStarColor()
	
	Local r:Int = StarColors[0]
	Local g:Int = StarColors[1]
	Local b:Int = StarColors[2]
	Local a1:Float = StarColors[3]
	Local a2:Float = StarColors[4]
	
	' Star Color variation
	STARVARIANCE = Rnd(1.0, Normalize(Int(System.SubClass), 9, 0, 1.0, 1.25))
		
	EntityColor glowmesh, r, g, b
	EntityColor flaremesh, r, g, b
		
	' colorize Star Body and Star Glow
	Local f1:Float = a1 / 255.0
	Local f2:Float = a2 / 255.0
	UpdateGlowColor(StarOuter1, r * (1 + f1), g * (1 + f1), b * (1 + f1), f1 * alpha1, r, g, b, 0)
	UpdateGlowColor(StarOuter2, r * (1 + f2), g * (1 + f2), b * (1 + f2), f2 * alpha2, r, g, b, 0)
	EntityColor StarMesh, r * f1, g * f1, b * f1
					
	' Calculate Zones Distances
	Local d1:Float = System.CalcMinimumHabitableZoneDistance() * System.AstronomicalUnitKM / 750000
	Local d2:Float = System.CalcOptimumHabitableZoneDistance() * System.AstronomicalUnitKM / 750000
	Local d3:Float = System.CalcMaximumHabitableZoneDistance() * System.AstronomicalUnitKM / 750000
	Local d4:Float = System.CalcZoneDistance(100) * System.AstronomicalUnitKM / 750000
			
	' use different zone scale for White Dwarfs
	If System.SpectralType = "W" Then
	
		d1:*Sqr(1.0 / dist) * 10
		d2:*Sqr(1.0 / dist) * 10
		d3:*Sqr(1.0 / dist) * 10
		d4:*Sqr(1.0 / dist) * 10
		
	EndIf

	' Update Zones Scale
	UpdateGlow(HotZone, 0.1, d2 * 1.25, ZoneSegments)
	UpdateGlow(HabZone, 0.1, d3 * 1.25, ZoneSegments)
	UpdateGlow(FroZone, 0.1, d4 * 1.25, ZoneSegments)

	' Rotate Zones Meshes
	RotateMesh HotZone, 90, 0, 0
	RotateMesh HabZone, 90, 0, 0
	RotateMesh FroZone, 90, 0, 0
		
End Function

# Star
DefData 4, 256, 0, 50
DefData 0, 0, 0, 0
DefData 10, 32, 32, 32
DefData 25, 128, 128, 128
DefData 100, 255, 255, 255

# Temp
DefData 6, 65535, 0, 50
DefData 0, 255, 0, 255
DefData 25, 0, 0, 255
DefData 50, 0, 255, 0
DefData 75, 255, 255, 0
DefData 100, 255, 0, 0

# ESA
DefData 21, 255, 0,50
DefData 0, 35, 73, 255
DefData 5, 34, 147, 223
DefData 10, 54, 209, 182
DefData 15, 96, 228, 109
DefData 20, 148, 227, 50
DefData 25, 196, 224, 33
DefData 30, 225, 211, 35
DefData 35, 233, 179, 36
DefData 40, 232, 127, 33
DefData 45, 231, 78, 40
DefData 50, 233, 78, 78
DefData 55, 229, 122, 131
DefData 60, 211, 144, 146
DefData 65, 184, 127, 114
DefData 70, 175, 120, 94
DefData 75, 189, 145, 112
DefData 80, 211, 177, 144
DefData 85, 223, 195, 168
DefData 90, 222, 200, 182
DefData 95, 224, 215, 210
DefData 100, 255, 255, 255