' SaveB3D(mesh:TMesh, f_name:String)
' SaveOBJ(mesh:TMesh,filename:String)



Global c_surfs:Int = 7
Global c_tex_name:String[c_surfs + 1]
Global b3d_stack:Int[100 + 1]
Global b3d_file:TStream, b3d_tos:Int

Function SaveB3D(mesh:TMesh, f_name:String)

	Local file:TStream = WriteFile(f_name)

	b3dSetFile(file)
	
	b3dBeginChunk("BB3D")

	b3dWriteInt(1)

	b3dBeginChunk("TEXS")
	For Local i:Int = 1 To c_surfs
		b3dWriteString(c_tex_name[i]) 	' texture file
		b3dWriteInt(1)					' flags
		b3dWriteInt(1)					' blend
		b3dWriteFloat(0)				' x in tex 0
		b3dWriteFloat(0)				' y in tex 0
		b3dWriteFloat(1)				' x scale 1
		b3dWriteFloat(1)				' y scale 1
		b3dWriteFloat(0)				' rotation 0
	Next
	b3dEndChunk()

	For Local i:Int = 1 To c_surfs
		b3dBeginChunk("BRUS") 			' describe all brushes used by the mesh
		b3dWriteInt(1)					' number of textures per brush ; (eg 2 with lightmap)
		b3dWriteString("brush" + (i - 1))	' brushname
		b3dWriteFloat(1)				' red
		b3dWriteFloat(1)				' green
		b3dWriteFloat(1)				' blue
		b3dWriteFloat(1)				' alpha
		b3dWriteFloat(0)				' shininess
		b3dWriteInt(1)					' blendmode
		b3dWriteInt(2)					' FX
		b3dWriteInt(i - 1)				' used texture index 
		b3dEndChunk()
	Next
		
	b3dBeginChunk("NODE")
	b3dWriteString("asteroid")
	b3dWriteFloat(0)					' x_pos
	b3dWriteFloat(0)					' y_pos
	b3dWriteFloat(0)					' z_pos
	b3dWriteFloat(1)					' x_scale
	b3dWriteFloat(1)					' y_scale
	b3dWriteFloat(1)					' z_scale
	b3dWriteFloat(1)					' rot_w
	b3dWriteFloat(0)					' rot_x
	b3dWriteFloat(0)					' rot_y
	b3dWriteFloat(0)					' rot_z
	WriteMESH(mesh)
	b3dEndChunk()
		
	b3dEndChunk()
	
	CloseFile file

End Function

Function WriteMESH(mesh:TMesh)

	Local n_surfs:Int = CountSurfaces(mesh)
	
	b3dBeginChunk("MESH")

	b3dWriteInt(-1)
		
	b3dBeginChunk("VRTS")
	b3dWriteInt(3)					'flags - 0=no normal/color
	b3dWriteInt(1)					'number of tex_coord sets (eg: 2 with lightmap)
	b3dWriteInt(2)					'coords per set (u,v,w?) 2 with uv, 3 with uvw
			
	For Local k:Int = 1 To n_surfs

		Local surf:TSurface = GetSurface(mesh, k)
		Local n_verts:Int = CountVertices(surf) - 1
				
		For Local j:Int = 0 To n_verts

			b3dWriteFloat(VertexX(surf, j))
			b3dWriteFloat(VertexY(surf, j))
			b3dWriteFloat(VertexZ(surf, j))
			b3dWriteFloat(VertexNX(surf, j))
			b3dWriteFloat(VertexNY(surf, j))
			b3dWriteFloat(VertexNZ(surf, j))
			b3dWriteFloat(VertexRed(surf, j))
			b3dWriteFloat(VertexGreen(surf, j))
			b3dWriteFloat(VertexBlue(surf, j))
			b3dWriteFloat(VertexAlpha(surf, j))
			b3dWriteFloat(VertexU(surf, j, 0))
			b3dWriteFloat(VertexV(surf, j, 0))
			'b3dWriteFloat(VertexU(surf,j,1))
			'b3dWriteFloat(VertexV(surf,j,1))

		Next

	Next

	b3dEndChunk()
		
	Local first_vert:Int = 0

	For Local k:Int = 1 To n_surfs

		Local surf:TSurface = GetSurface(mesh, k)
		Local n_tris:Int = CountTriangles(surf) - 1
			
		b3dBeginChunk("TRIS")

		b3dWriteInt(k - 1)
				
		For Local j:Int = 0 To n_tris
			b3dWriteInt(first_vert + TriangleVertex(surf, j, 0))
			b3dWriteInt(first_vert + TriangleVertex(surf, j, 1))
			b3dWriteInt(first_vert + TriangleVertex(surf, j, 2))
		Next
				
		b3dEndChunk()
			
		first_vert = first_vert + CountVertices(surf)
			
	Next
		
	b3dEndChunk()
	
End Function

Function b3dSetFile(file:TStream)

	b3d_tos = 0
	b3d_file = file

End Function

Function b3dWriteByte(n:Byte)

	WriteByte(b3d_file, n)

End Function

Function b3dWriteInt(n:Int)

	WriteInt(b3d_file, n)

End Function

Function b3dWriteFloat(n:Float)

	WriteFloat(b3d_file, n)

End Function

Function b3dWriteString(t:String)

	For Local k:Int = 1 To Len(t)

		Local ch:Byte = Asc(Mid(t, k, 1))
		b3dWriteByte(ch)
		If ch = 0 Then Return

	Next

	b3dWriteByte(0)

End Function

Function b3dBeginChunk(tag:String)

	b3d_tos = b3d_tos + 1

	For Local k:Int = 1 To 4

		b3dWriteByte(Asc(Mid(tag, k, 1)))

	Next

	b3dWriteInt(0)

	b3d_stack[b3d_tos] = StreamPos(b3d_file)

End Function

Function b3dEndChunk()

	Local n:Int = StreamPos(b3d_file)
	SeekStream b3d_file, b3d_stack[b3d_tos] - 4
	b3dWriteInt(n - b3d_stack[b3d_tos])
	SeekStream b3d_file, n
	b3d_tos = b3d_tos - 1

End Function



Function SaveOBJ(mesh:TMesh, filename:String)

	Local i:Int, j:Int, surf:TSurface
	Local file:TStream = WriteFile(filename)

	Local vx:Float, vy:Float, vz:Float
	Local nx:Float, ny:Float, nz:Float
	Local u:Float, v:Float
	Local a:Int, b:Int, c:Int

	' write materials
	

	' write vertices
	For i = 1 To CountSurfaces(mesh)
		surf = GetSurface(Mesh, i)
		For j = 0 To CountVertices(surf) - 1
			vx = VertexX(surf, j)
			vy = VertexY(surf, j)
			vz = VertexZ(surf, j)
			WriteLine(file, "v " + vx + " " + vy + " " + vz)
		Next
	Next

	' write vertex normals
	For i = 1 To CountSurfaces(mesh)
		surf = GetSurface(mesh, i)
		For j = 0 To CountVertices(surf) - 1
			nx = VertexNX(surf, j)
			ny = VertexNY(surf, j)
			nz = VertexNZ(surf, j)

			If (Not nx) Then nx = 0
			If (Not ny) Then ny = 0
			If (Not nz) Then nz = 0

			WriteLine(file, "vn " + nx + " " + ny + " " + nz)
		Next
	Next

	' write UV coordinates
	For i = 1 To CountSurfaces(mesh)
		surf = GetSurface(mesh, i)
		For j = 0 To CountVertices(surf) - 1
			u = VertexU(surf, j)
			v = -VertexV(surf, j)
			WriteLine(file, "vt " + u + " " + v)
		Next
	Next

	' write triangles including UV coordinate index
	For i = 1 To CountSurfaces(mesh)
		surf = GetSurface(mesh, i)
		For j = 0 To CountTriangles(surf) - 1
			a = TriangleVertex(surf, j, 0) + 1
			b = TriangleVertex(surf, j, 1) + 1
			c = TriangleVertex(surf, j, 2) + 1
			WriteLine(file, "f " + a + "/" + a + " " + b + "/" + b + " " + c + "/" + c)
		Next
	Next

End Function