' Distance2D:Float(x1:Float,y1:Float,x2:Float,y2:Float)
' Distance3D:Float(x1:Float,y1:Float,z1:Float,x2:Float,y2:Float,z2:Float)
' DeltaRoll:Float(Source:TEntity, Target:TEntity)
' AlignToTarget(source:TEntity, x:Float, y:Float, z:Float, angle:Float = 0.0)
' Spherize(mesh:TMesh)
' UpdateScale:Float(cam:TCamera, target:TEntity = Null, Scale:Float = 1.0, radius:Float = 1.0)


' ----------------------------------------------------------------------------
' 2D Distance Calculation
' ----------------------------------------------------------------------------
Function Distance2D:Float(x1:Float, y1:Float, x2:Float, y2:Float)
	
	Local x:Float = x1 - x2
	Local y:Float = y1 - y2
	
	Return Sqr(x * x + y * y)
	
End Function



' ----------------------------------------------------------------------------
' 3D Distance Calculation
' ----------------------------------------------------------------------------
Function Distance3D:Float(x1:Float, y1:Float, z1:Float, x2:Float, y2:Float, z2:Float)
	
	Local x:Float = x1 - x2
	Local y:Float = y1 - y2
	Local z:Float = z1 - z2
	
	Return Sqr(x * x + y * y + z * z)
	
End Function



' ----------------------------------------------------------------------------
' Calculate Delta between two Entity Roll Values
' ----------------------------------------------------------------------------
Function DeltaRoll:Float(Source:TEntity, Target:TEntity)

	TFormPoint 0, 0, 0, target, source
	Return VectorYaw (TFormedX() , 0, TFormedY())

End Function



' ------------------------------------------------------------------------------------------------
' Align Entity rotation to XYZ coordinates
' ------------------------------------------------------------------------------------------------
Function AlignToTarget(source:TEntity, x:Float, y:Float, z:Float, angle:Float = 0.0)
					
	Local yaw:Float, pitch:Float, roll:Float
	Local x1:Float, y1:Float, z1:Float
	Local x2:Float, y2:Float',z2:Float
	
	yaw = -ATan2(x, z)
	
	x1 = z * Sin(yaw) + x * Cos(yaw)
	y1 = y
	z1 = z * Cos(yaw) - x * Sin(yaw)
	
	pitch = -ATan2(y1, z1)

	x2 = x1
	y2 = y1 * Cos(pitch) - z1 * Sin(pitch)
	'z2=y1*Sin(pitch)+z1*Cos(pitch)
	
	roll = -ATan2(x2, y2)
	If y < 0 Then roll:+180
	
	RotateEntity source, pitch, yaw, roll' + angle
	
End Function



' ------------------------------------------------------------------------------------------------
' Align Entity rotation to XYZ coordinates using the Updatevalue function
' ------------------------------------------------------------------------------------------------
Function AlignToVector(e:TEntity, vx:Float, vy:Float, vz:Float, rate:Float = 1.0)

	Local pitch:Float = EntityPitch(e)
	Local yaw:Float = EntityYaw(e)
	Local roll:Float = EntityRoll(e)
	
	'TFormNormal(vx, vy, vz, e, Null)
	'vx = TFormedX()
	'vy = TFormedY()
	'vz = TFormedZ()

	Local dest_pitch:Float = Abs(ATan2(vz, vy))
	Local dest_roll:Float = Abs(-ATan2(vx, vy))
		
	pitch = UpdateValue(pitch, dest_pitch, rate)
	roll = UpdateValue(roll, dest_roll, rate)
		
	RotateEntity e, pitch, yaw, roll

End Function



' ----------------------------------------------------------------------------
' Spherize a segmented cube to a sphere shape
' ----------------------------------------------------------------------------
Function Spherize:TMesh(mesh:TMesh)

	For Local s:Int = 1 To CountSurfaces(mesh)
		
		Local surf:TSurface = GetSurface(mesh, s)
		
		For Local v:Int = 0 To CountVertices(surf) - 1
		
			Local vx:Float = VertexX(surf, v)
			Local vy:Float = VertexY(surf, v)
			Local vz:Float = VertexZ(surf, v)

			TFormNormal vx, vy, vz, Null, Null
			Local nx:Float = TFormedX()
			Local ny:Float = TFormedY()
			Local nz:Float = TFormedZ()
				
			VertexCoords surf, v, nx, ny, nz
			VertexNormal surf, v, nx, ny, nz
			
		Next
	
	Next
	
	Return mesh

End Function



' ----------------------------------------------------------------------------
' Updates the size of a mesh around a sphere according to camera distance
' ----------------------------------------------------------------------------
Function UpdateScale:Float(cam:TCamera, target:TEntity = Null, Scale:Float = 1.0, radius:Float = 1.0)
	
	Local c1:Float, a1:Float, q1:Float, p1:Float, h1:Float, alpha1:Float, beta1:Float, gamma1:Float, alpha2:Float, b2:Float, c2:Float
		
	c1 = EntityDistance(cam, target)
	a1 = radius
	q1 = a1 * a1 / c1
	p1 = c1 - q1
	h1 = Sqr(p1 * q1)
	gamma1 = 90
	alpha1 = ATan(h1 / p1)
	beta1 = gamma1 - alpha1
	
	alpha2 = 90 - (90 - beta1)
	b2 = a1 / Tan(alpha2)
	c2 = (Sqr(a1 * a1 + b2 * b2)) / radius * Scale
	
	Return c2
	
End Function