' CreateRing:TMesh(parent:TEntity = Null, segments:Int = 360, r1:Float, r2:Float, fx:Int = 1 + 16, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
' UpdateRing(mesh:TMesh, segments:Int = 360, r1:Float, r2:Float, fx:Int = 1 + 16, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)



' ------------------------------------------------------------------------------------------------
' Creates a Ring
' ------------------------------------------------------------------------------------------------
Function CreateRing:TMesh(parent:TEntity = Null, segments:Int = 360, r1:Float, r2:Float, fx:Int = 1 + 16, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	Local angle:Int, a1:Float, a2:Float, a3:Float, a4:Float
	Local v0:Int, v1:Int, v2:Int, v3:Int
	
	Local mesh:TMesh = CreateMesh(parent)
	Local surf:TSurface = CreateSurface(mesh)
	
	If SEGMENTS > 360 Then SEGMENTS = 360
	
	For angle = 1 To SEGMENTS Step 1
		
		a1 = angle * 360.0 / SEGMENTS - 360.0 / SEGMENTS
		a2 = angle * 360.0 / SEGMENTS + 360.0 / SEGMENTS
		a3 = angle * 360.0 / SEGMENTS + 180.0 / SEGMENTS
		a4 = angle * 360.0 / SEGMENTS - 180.0 / SEGMENTS
		
		v0 = AddVertex(surf, r1 * Cos(a1), r1 * Sin(a1), 0, 0, 0)
		v1 = AddVertex(surf, r1 * Cos(a2), r1 * Sin(a2), 0, 0, 0)
		v2 = AddVertex(surf, r2 * Cos(a3), r2 * Sin(a3), 0, 1, 1)
		v3 = AddVertex(surf, r2 * Cos(a4), r2 * Sin(a4), 0, 1, 1)
		
		VertexColor surf, v0, r, g, b, a
		VertexColor surf, v1, r, g, b, a
		VertexColor surf, v2, r, g, b, a
		VertexColor surf, v3, r, g, b, a
		
		AddTriangle surf, v2, v1, v0
		AddTriangle surf, v0, v3, v2
		
	Next

	For Local v:Int = 0 To CountVertices(surf) - 1
		
		VertexTexCoords surf, v, 0.5+(VertexX(surf, v)/2.0), 0.5+(-VertexY(surf, v)/2.0),0, 1
		
	Next
		
	EntityFX mesh, fx
	
	Return mesh
	
End Function



' ------------------------------------------------------------------------------------------------
' Updates a Ring
' ------------------------------------------------------------------------------------------------
Function UpdateRing(mesh:TMesh, segments:Int = 360, r1:Float, r2:Float, fx:Int = 1 + 16, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	Local angle:Int, a1:Float, a2:Float
	Local v:Int, v0:Int, v1:Int, v2:Int, v3:Int
	
	Local surf:TSurface = GetSurface(mesh, 1)
	
	If SEGMENTS > 360 Then SEGMENTS = 360
	
	For angle = 0 To SEGMENTS - 1 Step 1
		
		a1 = angle * 360.0 / SEGMENTS - 360.0 / SEGMENTS
		a2 = angle * 360.0 / SEGMENTS + 360.0 / SEGMENTS
		
		v0 = (angle * 4) + 0
		v1 = (angle * 4) + 1
		v2 = (angle * 4) + 2
		v3 = (angle * 4) + 3
		
		VertexCoords surf, v0, r1 * Cos(a1), 0, r1 * Sin(a1)
		VertexCoords surf, v1, r1 * Cos(a2), 0, r1 * Sin(a2)
		VertexCoords surf, v2, r2 * Cos(a2), 0, r2 * Sin(a2)
		VertexCoords surf, v3, r2 * Cos(a1), 0, r2 * Sin(a1)
		
		VertexColor surf, v0, r, g, b, a
		VertexColor surf, v1, r, g, b, a
		VertexColor surf, v2, r, g, b, a
		VertexColor surf, v3, r, g, b, a
		
	Next
	
	For v = 0 To CountVertices(surf) - 1
		
		VertexTexCoords surf, v, VertexX(surf, v), VertexZ(surf, v), 0, 1
		
	Next
	
	EntityFX mesh, fx
	
End Function