' Weld(mesh:TMesh,mode:Int=0)
' DrawUVmap(s:TSurface,size:Int=5,SV:Int=0)
' DrawTriangleNormals(s:TSurface,target:TEntity,length:Float=16,size:Int=5)
' DrawVertexNormals(s:TSurface,target:TEntity,length:Int=16,size:Int=5,SN:Int=0,SV:Int=0)



Type TTris

	Global list:TList = CreateList()

	Method New()

		ListAddLast(list, Self)

	End Method

	Method Remove()

		ListRemove(list, Self)

	End Method

	Field v0:Float[] = [0.0, 0.0, 0.0, 0.0, 0.0]
	Field v1:Float[] = [0.0, 0.0, 0.0, 0.0, 0.0]
	Field v2:Float[] = [0.0, 0.0, 0.0, 0.0, 0.0]

End Type



' ----------------------------------------------------------------------------
' Weld isolated vertices = reduces vertex count
' ----------------------------------------------------------------------------
Function Weld(mesh:TMesh, mode:Int = 0)

	Local v:Int[3]
	Local v1:Int, v2:Int, v3:Int
	Local Count:Int = 0

	' check all surfaces
	For Local surfs:Int = 1 To CountSurfaces(mesh)

		' get current surface
		Local s:TSurface = GetSurface(mesh, surfs)

		' check all triangles
		For Local tq:Int = 0 To CountTriangles(s) - 1

			' get triangles vertices
			v[0] = TriangleVertex(s, tq, 0)
			v[1] = TriangleVertex(s, tq, 1)
			v[2] = TriangleVertex(s, tq, 2)

			' create new vertex list
			Local t:TTris = New TTris

			' first vertex properties
			t.v0[0] = VertexX(s, v[0])
			t.v0[1] = VertexY(s, v[0])
			t.v0[2] = VertexZ(s, v[0])
			t.v0[3] = VertexU(s, v[0])
			t.v0[4] = VertexV(s, v[0])
	
			' second vertex properties
			t.v1[0] = VertexX(s, v[1])
			t.v1[1] = VertexY(s, v[1])
			t.v1[2] = VertexZ(s, v[1])
			t.v1[3] = VertexU(s, v[1])
			t.v1[4] = VertexV(s, v[1])

			' third vertex properties
			t.v2[0] = VertexX(s, v[2])
			t.v2[1] = VertexY(s, v[2])
			t.v2[2] = VertexZ(s, v[2])
			t.v2[3] = VertexU(s, v[2])
			t.v2[4] = VertexV(s, v[2])

		Next

		' delete old surface
		ClearSurface s

		' check all new vertices
		For Local t:TTris = EachIn TTris.list

			' find and set new first vertex
			v1 = FindVert(s, t.v0[3], t.v0[4])
			If v1 = -1 Then
				AddVertex s, t.v0[0], t.v0[1], t.v0[2], t.v0[3], t.v0[4]
				v1 = Count
				Count = Count + 1
			EndIf

			' find and set new second vertex
			v2 = FindVert(s, t.v1[3], t.v1[4])
			If v2 = -1 Then
				AddVertex s, t.v1[0], t.v1[1], t.v1[2], t.v1[3], t.v1[4]
				v2 = Count
				Count = Count + 1
			EndIf
		
			' find and set new third vertex
			v3 = FindVert(s, t.v2[3], t.v2[4])
			If v3 = -1 Then
				AddVertex s, t.v2[0], t.v2[1], t.v2[2], t.v2[3], t.v2[4]
				v3 = Count
				Count = Count + 1
			EndIf

			' create a new triangle
			AddTriangle s, v1, v2, v3

			t.Remove

		Next

		' reset counter
		Count = 0

	Next

	UpdateNormals mesh

End Function



' ----------------------------------------------------------------------------
' check if a vertex with the same UV coordinates already exists
' ----------------------------------------------------------------------------
Function FindVert:Int(su:TSurface, u:Float, v:Float)

	For Local t:Int = 0 To CountVertices(su) - 1

		If VertexU(su, t) = u Then
			If VertexV(su, t) = v Then
				Return t
			EndIf
		EndIf

	Next

	Return - 1

End Function



' ----------------------------------------------------------------------------
' calculate triangle midpoint position and triangle normals vector
' ----------------------------------------------------------------------------
Function TriangleNormals:Float[] (surf:TSurface, t:Int)

	Local v0:Int = TriangleVertex(surf, t, 0)
	Local v1:Int = TriangleVertex(surf, t, 1)
	Local v2:Int = TriangleVertex(surf, t, 2)

	Local vx0:Float = VertexX(surf, v0)
	Local vy0:Float = VertexY(surf, v0)
	Local vz0:Float = VertexZ(surf, v0)

	Local vx1:Float = VertexX(surf, v1)
	Local vy1:Float = VertexY(surf, v1)
	Local vz1:Float = VertexZ(surf, v1)

	Local vx2:Float = VertexX(surf, v2)
	Local vy2:Float = VertexY(surf, v2)
	Local vz2:Float = VertexZ(surf, v2)
	
	Local ax:Float = vx1 - vx0
	Local ay:Float = vy1 - vy0
	Local az:Float = vz1 - vz0
	
	Local bx:Float = vx2 - vx1
	Local by:Float = vy2 - vy1
	Local bz:Float = vz2 - vz1

	Local x:Float = (vx0 + vx1 + vx2) / 3
	Local y:Float = (vy0 + vy1 + vy2) / 3
	Local z:Float = (vz0 + vz1 + vz2) / 3

	Local nx:Float = ay * bz - az * by
	Local ny:Float = az * bx - ax * bz
	Local nz:Float = ax * by - ay * bx

	Local n:Float = Sqr(nx * nx + ny * ny + nz * nz)

	Return[x, y, z, nx / n, ny / n, nz / n]
	
End Function



' ----------------------------------------------------------------------------
' draw UV map of a given surface
' ----------------------------------------------------------------------------
Function DrawUVmap(s:TSurface, Size:Int = 5, SV:Int = 0)

	Local nx:Float, ny:Float, nz:Float
	Local width:Int = GraphicsWidth()
	Local Height:Int = GraphicsHeight()
	
	For Local t:Int = 0 To CountTriangles(s) - 1

		Local v0:Int = TriangleVertex(s, t, 0)
		Local v1:Int = TriangleVertex(s, t, 1)
		Local v2:Int = TriangleVertex(s, t, 2)

		' UV map
		SetColor(0, 255, 0)
		DrawLine VertexU(s, v0) * (width), VertexV(s, v0) * (Height), VertexU(s, v1) * (width), VertexV(s, v1) * (Height)
		DrawLine VertexU(s, v1) * (width), VertexV(s, v1) * (Height), VertexU(s, v2) * (width), VertexV(s, v2) * (Height)
		DrawLine VertexU(s, v2) * (width), VertexV(s, v2) * (Height), VertexU(s, v0) * (width), VertexV(s, v0) * (Height)

		' vertices
		If SV = 1 Then
			SetColor(255, 0, 0)
			DrawOval (VertexU(s, v0) * width) - (Size / 2), (VertexV(s, v0) * (Height)) - (Size / 2), Size, Size
			DrawOval (VertexU(s, v1) * width) - (Size / 2), (VertexV(s, v1) * (Height)) - (Size / 2), Size, Size
			DrawOval (VertexU(s, v2) * width) - (Size / 2), (VertexV(s, v2) * (Height)) - (Size / 2), Size, Size
		EndIf

	Next

End Function



' ----------------------------------------------------------------------------
' draws vertices and vertex normals of a given surface
' ----------------------------------------------------------------------------
Function DrawVertexNormals(camera:TCamera, s:TSurface, target:TEntity, Length:Int = 16, Size:Int = 5, SN:Int = 0, SV:Int = 0)

	Local width:Int = GraphicsWidth()
	Local Height:Int = GraphicsHeight()

	For Local v:Int = 0 To CountVertices(s) - 1

		' vertex position	
		Local x:Float = VertexX(s, v)
		Local y:Float = VertexY(s, v)
		Local z:Float = VertexZ(s, v)
		TFormPoint x, y, z, target, Null
		Local x0:Float = TFormedX()
		Local y0:Float = TFormedY()
		Local z0:Float = TFormedZ()

		' get normal
		Local nx:Float = VertexNX(s, v)
		Local ny:Float = VertexNY(s, v)
		Local nz:Float = VertexNZ(s, v)
		TFormNormal nx, ny, nz, target, Null
		Local x1:Float = x0 + TFormedX() / 256.0 * Length
		Local y1:Float = y0 + TFormedY() / 256.0 * Length
		Local z1:Float = z0 + TFormedZ() / 256.0 * Length

		' project vertex/normal start
		CameraProject camera, x0, y0, z0
		Local sx:Int = ProjectedX()
		Local sy:Int = ProjectedY()

		' project normal end
		CameraProject camera, x1, y1, z1
		Local ex:Int = ProjectedX()
		Local ey:Int = ProjectedY()

		' vertex point within screen coordinates?
		If sx > 0 And sy > 0 And sx < width And sy < Height Then

			' normal end point within screen coordinates?
			If ex > 0 And ey > 0 And ex < width And ey < Height Then

				' draw vertex normals
				If SN = 1 Then
					SetColor((nx + 1) * 127.5, (ny + 1) * 127.5, (nz + 1) * 127.5)
					DrawLine sx, sy, ex, ey
					If SV = 0 Then DrawOval sx - (Size / 2), sy - (Size / 2), Size, Size
				EndIf

				' draw vertices
				If SV = 1 Then
					SetColor 255, 0, 0
					DrawOval sx - (Size / 2), sy - (Size / 2), Size, Size
				EndIf

			EndIf

		EndIf

	Next

End Function



' ----------------------------------------------------------------------------
' draws triangle normals of a given surface
' ----------------------------------------------------------------------------
Function DrawTriangleNormals(camera:TCamera, s:TSurface, target:TEntity, Length:Float = 16, Size:Int = 5)

	Local width:Int = GraphicsWidth()
	Local Height:Int = GraphicsHeight()

	For Local t:Int = 0 To CountTriangles(s) - 1

		' calculate triangle midpoint and triangle normal
		Local n:Float[] = TriangleNormals(s, t)

		' midpoint XYZ
		TFormPoint n[0], n[1], n[2], target, Null
		Local x0:Float = TFormedX()
		Local y0:Float = TFormedY()
		Local z0:Float = TFormedZ()

		' project normal start
		CameraProject camera, x0, y0, z0
		Local sx:Int = ProjectedX()
		Local sy:Int = ProjectedY()

		' project normal end
		TFormNormal n[3], n[4], n[5], target, Null
		Local x1:Float = x0 + TFormedX() / 256.0 * Length
		Local y1:Float = y0 + TFormedY() / 256.0 * Length
		Local z1:Float = z0 + TFormedZ() / 256.0 * Length
		CameraProject camera, x1, y1, z1
		Local ex:Int = ProjectedX()
		Local ey:Int = ProjectedY()

		' vertex point within screen coordinates?
		If sx > 0 And sy > 0 And sx < width And sy < Height Then

			' normal end point within screen coordinates?
			If ex > 0 And ey > 0 And ex < width And ey < Height Then

				SetColor((n[3] + 1) * 127.5, (n[4] + 1) * 127.5, (n[5] + 1) * 127.5)
				DrawOval sx - (Size / 2), sy - (Size / 2), Size, Size
				DrawLine sx, sy, ex, ey

			EndIf

		EndIf

	Next

End Function