' CalculateMeshNormals(mesh:TMesh)
' NormalizeNormals(mesh:TMesh)
' CalcNormals(ThisMesh:TMesh)



' --------------------------------------------------------------------------------
' Recalculate the Mesh Normals
' --------------------------------------------------------------------------------
Function CalculateMeshNormals(mesh:TMesh)

	Local s:Int, v:Int
	Local surf:TSurface
	Local nx:Float, ny:Float, nz:Float, d:Float

	' Recalculate (normalize) normals
	For s = 1 To CountSurfaces(mesh)
		
		' Get Surfaces
		surf = GetSurface(mesh, s)
		
		' Iterate through all Vertices
		For v = 0 To CountVertices(surf) - 1
			
			' Get Normals
			nx = VertexNX(surf, v)
			ny = VertexNY(surf, v)
			nz = VertexNZ(surf, v)
			
			' Normalize Vector
			d = 1.0 / Sqr(nx * nx + ny * ny + nz * nz)
			
			' Store new Normals
			VertexNormal surf, v, nx * d, ny * d, nz * d
			
		Next
				
	Next
	
End Function



' --------------------------------------------------------------------------------
' Normalizes the Mesh Normals
' --------------------------------------------------------------------------------
Function NormalizeNormals(mesh:TMesh)

	Local s:Int
	Local v:Int
	
	Local surf:TSurface
	
	Local nx:Float
	Local ny:Float
	Local nz:Float
	
	Local d:Float
	
	For s = 1 To CountSurfaces(mesh)
	
		surf = GetSurface(mesh, s)
	
		For v = 0 To CountVertices(surf) - 1
	
			nx = VertexNX(surf, v)
			ny = VertexNY(surf, v)
			nz = VertexNZ(surf, v)
			
			d = Sqr(nx * nx + ny * ny + nz * nz)
	
			nx = nx / d
			ny = ny / d
			nz = nz / d
		
			VertexNormal surf, v, nx, ny, nz
	
		Next
	
	Next

End Function



' ----------------------------------------------------------------------------
' Calculate Normals of a Mesh
' ----------------------------------------------------------------------------

Global Face_NX:Float[32768]
Global Face_NY:Float[32768]
Global Face_NZ:Float[32768]
Global Vertex_ConnectedTris:Int[32768]
Global Vertex_TriList:Int[32768,32]

Function CalcNormals(ThisMesh:TMesh)

	Local Surfaces:Int
	Local LOOP_Surface:Int
	Local Surface_Handle:TSurface
	Local LoopV:Int
	Local Tris:Int
	Local LOOP_Tris:Int
	Local Vertex_0:Int,Vertex_1:Int,Vertex_2:Int
	Local ConnectedTris:Int
	Local Vertices:Int
	Local LOOP_Vertices:Int
	Local Polys:Int
	Local LOOP_Polys:Int

	Local Ax:Float,Ay:Float,Az:Float
	Local Bx:Float,By:Float,Bz:Float
	Local Cx:Float,Cy:Float,Cz:Float

	Local Px:Float,Py:Float,Pz:Float
	Local Qx:Float,Qy:Float,Qz:Float
	Local Nx:Float,Ny:Float,Nz:Float

	Local Nl:Float
	Local ThisPoly:Int
	
	' Loop through all surfaces of the mesh.
	Surfaces = CountSurfaces(ThisMesh)
	For LOOP_Surface = 1 To Surfaces

		Surface_Handle = GetSurface(ThisMesh, LOOP_Surface)

		' Reset the number of connected polygons For each vertex.
		For LoopV = 0 To 32767	
			Vertex_ConnectedTris[LoopV] = 0
		Next	
	
		' Loop through all triangles in this surface of the mesh.
		Tris = CountTriangles(Surface_Handle)
		For LOOP_Tris = 0 To Tris-1

				' Get the vertices that make up this triangle.
				Vertex_0 = TriangleVertex(Surface_Handle, LOOP_Tris, 0)
				Vertex_1 = TriangleVertex(Surface_Handle, LOOP_Tris, 1)
				Vertex_2 = TriangleVertex(Surface_Handle, LOOP_Tris, 2)
	
				' Adjust the number of triangles each vertex is connected To And
				' store this triangle in each vertex's list of triangles it is connected to.
				ConnectedTris = Vertex_ConnectedTris[Vertex_0]
				Vertex_TriList[Vertex_0, ConnectedTris] = LOOP_Tris
				Vertex_ConnectedTris[Vertex_0] = ConnectedTris + 1

				ConnectedTris = Vertex_ConnectedTris[Vertex_1]
				Vertex_TriList[Vertex_1, ConnectedTris] = LOOP_Tris
				Vertex_ConnectedTris[Vertex_1] = ConnectedTris + 1

				ConnectedTris = Vertex_ConnectedTris[Vertex_2]
				Vertex_TriList[Vertex_2, ConnectedTris] = LOOP_Tris
				Vertex_ConnectedTris[Vertex_2] = ConnectedTris + 1

				' Calculate the normal For this face.

				' Get the corners of this face:
				Ax=VertexX(Surface_Handle,Vertex_0)
				Ay=VertexY(Surface_Handle,Vertex_0)
				Az=VertexZ(Surface_Handle,Vertex_0)

				Bx=VertexX(Surface_Handle,Vertex_1)
				By=VertexY(Surface_Handle,Vertex_1)
				Bz=VertexZ(Surface_Handle,Vertex_1)

				Cx=VertexX(Surface_Handle,Vertex_2)
				Cy=VertexY(Surface_Handle,Vertex_2)
				Cz=VertexZ(Surface_Handle,Vertex_2)

				' Triangle 1
				' Get the vectors For two edges of the triangle.
				Px=Ax-Bx
				Py=Ay-By
				Pz=Az-Bz

				Qx=Bx-Cx
				Qy=By-Cy
				Qz=Bz-Cz

				' Compute their cross product.
				Nx=Py*Qz-Pz*Qy
				Ny=Pz*Qx-Px*Qz
				Nz=Px*Qy-Py*Qx

				' Store the face normal.
				Face_NX[LOOP_Tris]=Nx
				Face_NY[LOOP_Tris]=Ny
				Face_NZ[LOOP_Tris]=Nz

		Next

		' Now that all the face normals For this surface have been calculated, calculate the vertex normals.
		Vertices = CountVertices(Surface_Handle)
		For LOOP_Vertices = 0 To Vertices-1

			' Reset this normal.
			Nx=0
			Ny=0
			Nz=0

			' Add the normals of all polygons which are connected To this vertex.
			Polys = Vertex_ConnectedTris[LOOP_Vertices]
				
			For LOOP_Polys = 0 To Polys-1

				ThisPoly = Vertex_TriList[LOOP_Vertices, LOOP_Polys]

				Nx=Nx+Face_NX[ThisPoly]
				Ny=Ny+Face_NY[ThisPoly]
				Nz=Nz+Face_NZ[ThisPoly]
				
			Next	
				
			' Normalize the New vertex normal.
			' (Normalizing is scaling the vertex normal down so that it's length = 1)

			Nl=Sqr(Nx^2+Ny^2+Nz^2)

			' Avoid a divide by zero error If by some freak accident, the vectors add up To 0.
			' If Nl:Float = 0 Then Nl:Float = 0.1

			Nx=Nx/Nl
			Ny=Ny/Nl
			Nz=Nz/Nl

			' Set the vertex normal.
			VertexNormal Surface_Handle,LOOP_Vertices,Nx,Ny,Nz
			VertexColor Surface_Handle,LOOP_Vertices,(nx+1)*127.5,(ny+1)*127.5,(nz+1)*127.5
		
		Next

	Next

End Function