' ZOrder_Init:TZorder(mesh:TMesh, include_y:Int = False)
' ZOrder_Update(zo:TZorder, cam:TCamera)
' ZOrder_SortBank(bankA:TBank, bankB:TBank, l:Int, r:Int)



Type TZorder

	Field mesh:TMesh
	Field surf:TSurface
	Field x:TBank
	Field y:TBank
	Field z:TBank
	Field n_tris:Int
	Field include_y:Int
	Field prev:Int
	
End Type



' ------------------------------------------------------------------------------------------------
' Initializes a Zorder Sorting Type
' ------------------------------------------------------------------------------------------------
Function ZOrder_Init:TZorder(mesh:TMesh, include_y:Int = False)
	
	Local ft:Int
	Local t:Int
	
	Local zo:TZorder = New TZorder
	zo.mesh = mesh
	zo.surf = GetSurface(zo.mesh, 1)
	
	If zo.surf = Null
	
		RuntimeError "Zorderize(): No surface found!"
		
	EndIf
	
	zo.include_y = include_y
	zo.n_tris = CountTriangles(zo.surf) - 1
	
	Local tempbank:TBank = CreateBank((zo.n_tris + 1) * 4)
	
	' X axis sorting
	zo.x = CreateBank((zo.n_tris + 1) * 6)
	
	For t = 0 To zo.n_tris
	
		ft = t * 6
		
		PokeShort zo.x, ft + 0, TriangleVertex(zo.surf, t, 0)
		PokeShort zo.x, ft + 2, TriangleVertex(zo.surf, t, 1)
		PokeShort zo.x, ft + 4, TriangleVertex(zo.surf, t, 2)
		PokeFloat tempbank, t * 4, VertexX(zo.surf, TriangleVertex(zo.surf, t, 0)) + VertexX(zo.surf, TriangleVertex(zo.surf, t, 1)) + VertexX(zo.surf, TriangleVertex(zo.surf, t, 2))
		
	Next
		
	If BankSize(tempbank) > 0 Then ZOrder_SortBank(tempbank, zo.x, 0, zo.n_tris)
	
	If include_y Then
	
		' Y axis sorting
		zo.y = CreateBank((zo.n_tris + 1) * 6)
		
		For t = 0 To zo.n_tris
		
			ft = t * 6
			
			PokeShort zo.y, ft + 0, TriangleVertex(zo.surf, t, 0)
			PokeShort zo.y, ft + 2, TriangleVertex(zo.surf, t, 1)
			PokeShort zo.y, ft + 4, TriangleVertex(zo.surf, t, 2)
			PokeFloat tempbank, t * 4, VertexY(zo.surf, TriangleVertex(zo.surf, t, 0)) + VertexY(zo.surf, TriangleVertex(zo.surf, t, 1)) + VertexY(zo.surf, TriangleVertex(zo.surf, t, 2))
			
		Next
		
		If BankSize(tempbank) > 0 Then ZOrder_SortBank(tempbank, zo.y, 0, zo.n_tris)
		
	EndIf
	
	' Z axis sorting
	zo.z = CreateBank((zo.n_tris + 1) * 6)
	
	For t = 0 To zo.n_tris
	
		ft = t * 6
		
		PokeShort zo.z, ft + 0, TriangleVertex(zo.surf, t, 0)
		PokeShort zo.z, ft + 2, TriangleVertex(zo.surf, t, 1)
		PokeShort zo.z, ft + 4, TriangleVertex(zo.surf, t, 2)
		PokeFloat tempbank, t * 4, VertexZ(zo.surf, TriangleVertex(zo.surf, t, 0)) + VertexZ(zo.surf, TriangleVertex(zo.surf, t, 1)) + VertexZ(zo.surf, TriangleVertex(zo.surf, t, 2))
		
	Next
	
	If BankSize(tempbank) > 0 Then ZOrder_SortBank(tempbank, zo.z, 0, zo.n_tris)
	
	tempbank = Null
	
	Return zo
	
End Function



' ------------------------------------------------------------------------------------------------
' Updates a given Zorder Object
' ------------------------------------------------------------------------------------------------
Function ZOrder_Update(zo:TZorder, cam:TCamera)
	
	Local t:Int
	Local tf:Int
	
	TFormVector 0, 0, 1, cam, Null
	
	Local tx:Float = TFormedX()
	Local ty:Float = TFormedY()
	Local tz:Float = TFormedZ()
	
	Local temp:Int = 0
	Local bank:TBank
	
	If zo.include_y = False Then ty = 0.0
	
	If (Abs(tx) > Abs(tz)) And (Abs(tx) > Abs(ty))
	
		temp = Sgn(tx)
		bank = zo.x
		
	ElseIf Abs(ty) > Abs(tz)
	
		temp = Sgn(ty) * 2
		bank = zo.y
		
	Else
	
		temp = Sgn(tz) * 3
		bank = zo.z
		
	EndIf
	
	If temp <> zo.prev
		
		zo.prev = temp
		ClearSurface zo.surf, 0, 1
		
		Select Sgn(zo.prev)
		
			Case 1
				For t = 0 To zo.n_tris
				
					tf = t * 6
					AddTriangle (zo.surf, PeekShort(bank, tf), PeekShort(bank, tf + 2), PeekShort(bank, tf + 4))
					
				Next
				
			Case - 1
			
				For t = zo.n_tris To 0 Step - 1
				
					tf = t * 6
					AddTriangle (zo.surf, PeekShort(bank, tf), PeekShort(bank, tf + 2), PeekShort(bank, tf + 4))
					
				Next
				
		End Select
		
	EndIf
	
End Function



' ------------------------------------------------------------------------------------------------
' Sort the ZOrder Bank
' ------------------------------------------------------------------------------------------------
Function ZOrder_SortBank(bankA:TBank, bankB:TBank, l:Int, r:Int)

	Local P:Int
	Local q:Int
	Local x:Float
	Local F:Float
	
	Local V0:Int
	Local V1:Int
	Local V2:Int
	
	P = l
	q = r
	
	x = PeekFloat(bankA, ((l + r) / 2) * 4)
	
	Repeat
	
	While PeekFloat(bankA, P * 4) > x
		
		P = P + 1
			
	Wend
		
	While x > PeekFloat(bankA, q * 4)
		
		q = q - 1
			
	Wend
		
	If p > q Then Exit
		
	V0 = PeekShort(bankB, q * 6 + 0)
	V1 = PeekShort(bankB, q * 6 + 2)
	V2 = PeekShort(bankB, q * 6 + 4)
				
	PokeShort bankB, q * 6 + 0, PeekShort(bankB, P * 6 + 0)
	PokeShort bankB, q * 6 + 2, PeekShort(bankB, P * 6 + 2)
	PokeShort bankB, q * 6 + 4, PeekShort(bankB, P * 6 + 4)
				
	PokeShort bankB, P * 6 + 0, V0
	PokeShort bankB, P * 6 + 2, V1
	PokeShort bankB, P * 6 + 4, V2
				
	F = PeekFloat(bankA, q * 4)
	PokeFloat bankA, q * 4, PeekFloat(bankA, P * 4)
	PokeFloat bankA, P * 4, F
		
	P:+1
	q:-1
		
	If q < 0 Then Exit
		
	Forever
	
	If l < q Then ZOrder_SortBank(bankA, bankB, l, q)
	If P < r Then ZOrder_SortBank(bankA, bankB, P, r)
		
End Function