' DrawOrbit(radius:Float=1.0,r:Int=255,g:Int=255,b:Int=255,a:Float=1.0,offx:Float=1.0,offy:Float=1.0,offz:Float=1.0)
' Line3D:TMesh(x0:Float, y0:Float, z0:Float, x1:Float, y1:Float, z1:Float, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
' SetFOV:Float(angle:Float)
' RenderWireframe()
' RenderSolid()

Include "F3D.2D.bmx"
Include "F3D.Format.bmx"
Include "F3D.Light.bmx"
Include "F3D.Math.bmx"
Include "F3D.Mesh.bmx"
Include "F3D.Mesh.Glow.bmx"
Include "F3D.Mesh.Primitives.bmx"
Include "F3D.Mesh.Ring.bmx"
Include "F3D.Normals.bmx"
Include "F3D.Normals.Display.bmx"
Include "F3D.Normals.Recalc.bmx"
Include "F3D.Surface.bmx"
Include "F3D.Texture.bmx"
Include "F3D.Zorder.bmx"



' ------------------------------------------------------------------------------------------------
' Draw Orbit using OpenGL functions
' ------------------------------------------------------------------------------------------------
Function DrawOrbit(radius:Float = 1.0, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0, offx:Float = 1.0, offy:Float = 1.0, offz:Float = 1.0)

	Local i:Int
	Local x1:Float, y1:Float, z1:Float
	Local x2:Float, y2:Float, z2:Float

	glEnable(GL_COLOR_MATERIAL)
	glLineWidth(1.0)
	glBegin(GL_LINES)

	For i = 0 To 359
	
		x1 = Sin(i) * radius
		y1 = 0
		z1 = Cos(i) * radius
		x2 = Sin(i + 1) * radius
		y2 = 0
		z2 = Cos(i + 1) * radius
			
		Line3D(x1 + offx, y1 + offy, z1 + offz, x2 + offx, y2 + offy, z2 + offz, r, g, b, a)
			
	Next

	glEnd()
	glDisable(GL_COLOR_MATERIAL)

End Function



' ------------------------------------------------------------------------------------------------
' Draw a 3D line using OpenGL functions:
' glEnable(GL_COLOR_MATERIAL) / glBegin(GL_LINES) [...] glEnd() / glDisable(GL_COLOR_MATERIAL)
' ------------------------------------------------------------------------------------------------
Function Line3D:TMesh(x0:Double, y0:Double, z0:Double, x1:Double, y1:Double, z1:Double, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
		
	SetColor r, g, b
	SetAlpha(a)
		
	glVertex3f(x0, y0, -z0)
	glVertex3f(x1, y1, -z1)
	
	SetAlpha(1.0)
			
End Function



' ----------------------------------------------------------------------------
' Convert a given Field of View angle to a Camerazoom value
' ----------------------------------------------------------------------------
Function SetFOV:Float(angle:Float)
	
	Return 1.0 / Tan(angle / 2.0)
	
End Function



' ------------------------------------------------------------------------------------------------
' Render the next Element in Wireframe Mode
' ------------------------------------------------------------------------------------------------
Function RenderWireframe()

	glDisable GL_TEXTURE_2D
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE)

End Function



' ------------------------------------------------------------------------------------------------
' Render the next Element in Solid Mode
' ------------------------------------------------------------------------------------------------
Function RenderSolid()

	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL)
	glEnable GL_TEXTURE_2D

End Function



' ------------------------------------------------------------------------------------------------
' Retrieve and filter available Graphics Resolutions
' ------------------------------------------------------------------------------------------------
Global GUI_Resolutions:String[999]
Global CURRENT_Width:Int
Global CURRENT_Height:Int
Function GetResolutions()

	Local w:Int
	Local h:Int
	Local d:Int
	Local z:Int

	Local m:Int
	Local i:Int
	
	Local Add:Int
	Local index:Int = 0

	' iterate through all graphic modes
	For m = 0 To CountGraphicsModes() - 1
	
		' get available graphic modes and store them in variables
		GetGraphicsMode(m, w, h, d, z)
		
		' assuming we're adding them
		Add = True
		
		' Resolution is already known or height too small? sort them out!
		For i = 0 To index
		
			If GUI_Resolutions[i] = (w + "x" + h) Or h < 720 Then Add = False ; Exit
		
		Next
				
		' add all other resolutions to our Pulldown menu
		If Add Then
					
			' if the current Resolution matches Desktop resolution: preselect it!
			If w = DesktopWidth() And h = DesktopHeight() Then
			
				CURRENT_Width = w
				CURRENT_Height = h
				
			EndIf
			
			' store the new Resolution in Array
			GUI_Resolutions[index] = w + "x" + h
			
			' counter
			index:+1
						
		EndIf
				
	Next

End Function