' GetAngle:Float(x1:Float, y1:Float, x2:Float, y2:Float)
' DegToRad:Float(degrees:Float)
' CosD:Float(degrees:Float)
' SinD:Float(degrees:Float)



' ------------------------------------------------------------------------------------------------
' Calculates the angle between two XY coordinates
' ------------------------------------------------------------------------------------------------
Function GetAngle:Float(x1:Float, y1:Float, x2:Float, y2:Float)

	Return ATan2(y2 - y1, x2 - x1)
	
End Function



' ------------------------------------------------------------------------------------------------
' Convert Degrees to Radians
' ------------------------------------------------------------------------------------------------
Function DegToRad:Float(degrees:Float)

	Return degrees * Pi / 180.0

End Function



' ------------------------------------------------------------------------------------------------
' Cosinus Degrees
' ------------------------------------------------------------------------------------------------
Function CosD:Float(degrees:Float)

	Return Cos(degrees * 0.017453292519943295)

End Function



' ------------------------------------------------------------------------------------------------
' Sinus Degrees
' ------------------------------------------------------------------------------------------------
Function SinD:Float(degrees:Float)

	Return Sin(degrees * 0.017453292519943295)

End Function