' ResetMouse()
' CenterMouse()
' MouseZoomValue:Float(MinZoom:Float = 0.0, MaxZoom:Float = 1.0, resolution:Float = 0.1, Steps:Float = 20)
' MouseZSpeed:Float(speed_modifier:Float = 1.0)
' Movement(target:TEntity, movespeed:Float = 1.0, sensitivity:Float = 1.0, turnspeed:Float = 4.0, rollspeed:Float = 2)



' ------------------------------------------------------------------------------------------------
' Reset Mouse to Screen Center
' ------------------------------------------------------------------------------------------------
Function ResetMouse()

	MoveMouse GraphicsWidth() / 2, GraphicsHeight() / 2
	
	MouseXSpeed()
	MouseYSpeed()
	MouseZSpeed()
	
End Function



' ------------------------------------------------------------------------------------------------
' Move Mouse pointer to Screen Center
' ------------------------------------------------------------------------------------------------
Function CenterMouse()

	MoveMouse GraphicsWidth() / 2, GraphicsHeight() / 2

End Function



' ------------------------------------------------------------------------------------------------
' Mouse Zoom Value
' ------------------------------------------------------------------------------------------------
Function MouseZoomValue:Float(MinZoom:Float = 0.0, MaxZoom:Float = 1.0, resolution:Float = 0.1, Steps:Float = 20)

	Global zoom:Float = 1.0, target:Float = 1.0
	Local EPSILON:Float, tdelta:Float

	Steps = Max(Steps, 1)
	EPSILON = resolution / Steps
	target = Max(Min(target + (MouseZSpeed(resolution)), MaxZoom), MinZoom)

	tdelta = target - zoom
	If Abs(tdelta) < EPSILON Then zoom = target Else zoom = zoom + tdelta / Steps

	Return zoom
	
End Function



' ------------------------------------------------------------------------------------------------
' MouseZSpeed
' ------------------------------------------------------------------------------------------------
Function MouseZSpeed:Float(speed_modifier:Float = 1.0)

	Global Lastz:Float, Newz:Float
	Lastz = Newz
	Newz = -MouseZ()
	Return (Newz - Lastz) * speed_modifier
	
End Function

' ------------------------------------------------------------------------------------------------
' Simple 3D Movement using Quaternions
' ------------------------------------------------------------------------------------------------
Function Movement(target:TEntity, movespeed:Float = 1.0, sensitivity:Float = 1.0, turnspeed:Float = 4.0, rollspeed:Float = 2)
	
	Local width:Int = GraphicsWidth()
	Local Height:Int = GraphicsHeight()
	Local multi:Int = 1

	Local roll:Float, cz:Float, tx:Float, ty:Float, Pos:Float
	
	cz = (KeyDown(KEY_UP) - KeyDown(KEY_DOWN) + (KeyDown(KEY_W) - KeyDown(KEY_S)))
	roll = (KeyDown(KEY_LEFT) - KeyDown(KEY_RIGHT) + (KeyDown(KEY_A) - KeyDown(KEY_D)))
	multi = 1 + ((KeyDown(KEY_LSHIFT) + KeyDown(KEY_RSHIFT)) * 10)
	
	tx = Normalize(MouseX(), 0, width, 1, -1)
	ty = Normalize(MouseY(), 0, Height, -1, 1)
	
	If ty < 0 Then ty = (Abs(ty) ^ sensitivity) * -1 Else ty = ty ^ sensitivity
	If tx < 0 Then tx = (Abs(tx) ^ sensitivity) * -1 Else tx = tx ^ sensitivity
	
	Turn target, ty * turnspeed, tx * turnspeed, roll * rollspeed

	MoveEntity target, 0, 0, cz * movespeed * multi
	
End Function