' Noise:Float(x:Int,y:Int,seed:Int)
' Noise3D:Float(x:Float, y:Float, z:Float)

'Include "FNoise.Fast.bmx"
Include "FNoise.Perlin.bmx"



' --------------------------------------------------------------------------------------------
' Simple Noise Function
' --------------------------------------------------------------------------------------------
Function Noise1D:Float(x:Int, y:Int, seed:Int)
	
	Local n:Int = x + y * 57 + seed
	
	n = n Shl Int(Floor((13 ^ n)))
	
	Return (1.0 - ((n * (n * n * 15731 + 789221) + 1376312589) & $7fffffff) / 1073741824.0)
	
End Function

rem


' --------------------------------------------------------------------------------------------
' Create Simplex Noise at X,Y,Z
' --------------------------------------------------------------------------------------------
Function XNoise3D:Float(x:Float, y:Float, z:Float, seed:Int = 1, Scale:Float = 1.0, octaves:Int = 7, persistence:Float = 0.7)
	
	x:+seed + 1
	y:+seed + 1
	z:+seed + 1
	
	Local total:Float = 0
	Local frequency:Float = Scale
	Local amplitude:Float = 1
	Local maxamplitude:Float = 0
		
	For Local i:Int = 0 To octaves - 1
			
		total:+XNoise3D(x * frequency, y * frequency, z * frequency) * amplitude
		frequency:*2
		maxamplitude:+amplitude
		amplitude:*persistence
		
	Next
		
	Return total / maxamplitude
	
End Function

endrem