﻿' ------------------------------------------------------------------------------------------------
' 2D GUI Output
' ------------------------------------------------------------------------------------------------
Function GUI()

	BeginMax2D
			
		SetBlend SOLIDBLEND
			
		' --------------------------------------------------------------------------------------------
		' Title output
		' --------------------------------------------------------------------------------------------
		If FLAG.Get("TITLE") Then
		
			SetScale(Scaler, Scaler)
			
			If TSound(MEDIA.GetSound("BLIP")) Then TITLE_CHANNEL = CueSound(MEDIA.GetSound("BLIP")) Else StopChannel TITLE_CHANNEL
	
			SetBlend ALPHABLEND
			SetAlpha(TITLE_ALPHA)
			SetImageFont(MEDIA.GetFont("SYSTEM"))
	
			Local sx:Int = SCREEN_WIDTH / 32
			Local sy:Int = SCREEN_HEIGHT / 1.7
					
			SetColor 0, 0, 0
			DrawLines(TITLE_OUTPUT, sx + (3 * Scaler), sy + (3 * Scaler))
			
			SetColor 0, 128, 255
						
			DrawLines(TITLE_OUTPUT, sx, sy)
	
			SetScale(Scaler, Scaler)
			SetAlpha(1.0)
	
		EndIf
		
		' --------------------------------------------------------------------------------------------
		' Debug Font size tests
		' --------------------------------------------------------------------------------------------
		If FLAG.Get("FONT") Then
		
			SetScale(Scaler, Scaler)
				
			' draw large text
			SetBlend ALPHABLEND
			SetImageFont(MEDIA.GetFont("LARGE"))
			Titleoutput()
			
			' Begin drawin GL Lines
			glDisable(GL_TEXTURE_2D)
			glEnable(GL_COLOR_MATERIAL)
			glBegin(GL_LINES)
			glLineWidth(1.0)
				
			' Scaling Dimensions and Center
			Local sw:Int = 2432 * scaler
			Local sh:Int = 256 * scaler
			Local wx:Int = SCREEN_WIDTH / 2
			Local hx:Int = SCREEN_HEIGHT / 2
				
			' Title Frame
			SetColor(0, 255, 0)
			SetAlpha(0.5)
			DrawGRect(wx - (sw / 2), hx - (sh / 2), sw, sh)
				
			' Title Center Line
			SetColor(255, 0, 255)
			DrawGLine(wx - (sw / 2), hx, wx + (sw / 2), hx)
						
			' End drawing GL Lines
			glEnd()
			glDisable(GL_COLOR_MATERIAL)
			glEnable(GL_TEXTURE_2D)
			
			SetAlpha(1.0)
			
		EndIf
			
		' --------------------------------------------------------------------------------------------
		' GUI output
		' --------------------------------------------------------------------------------------------
		If FLAG.Get("GUI") Then
															
			' draw GUI small text
			Font("SMALL")
			SystemInfo()
			
		EndIf
		
		' --------------------------------------------------------------------------------------------
		' Onscreen Planet Infos
		' --------------------------------------------------------------------------------------------
		If FLAG.Get("PLANETS") Then
	
			SetScale(Scaler, Scaler)
			SetColor(255, 255, 255)
			SetAlpha(1.0)
			Font("MICRO")
						
			For Local s:TSystemObject = EachIn planetlist
			
				s.x = EntityX(s.ent, 1)
				s.y = EntityY(s.ent, 1)
				s.z = EntityZ(s.ent, 1)
					
				' Object Text
				TFormPoint(s.x, s.y, s.z, Null, CAMERA.cam)
			
				If TFormedZ() > 0 And (Not s.toohot) Then
				
					s.Alpha = Normalize(EntityDistance(CAMERA.cam, StarMesh), 0, maxdist * 2, 1, 0)
					SetAlpha(s.Alpha)
					If s.id = 0 Then SetAlpha(0.0)
					
					CameraProject(CAMERA.cam, s.x, s.y, s.z)
					Local x1:Float = ProjectedX()
					Local y1:Float = ProjectedY()
														
					SetColor 0, 255, 0
									
					DrawText s.id, x1, y1
								
				EndIf
			
			Next
	
			SetScale(1.0, 1.0)
				
		EndIf
				
		' --------------------------------------------------------------------------------------------
		' FPS output
		' --------------------------------------------------------------------------------------------
		If FLAG.Get("FPS") Then DrawFPS
			
		' Reset Scaling
		SetScale(1.0, 1.0)

	EndMax2D

End Function



' ------------------------------------------------------------------------------------------------
' Fade out Title infos after a period of time
' ------------------------------------------------------------------------------------------------
Function FadeBlip(Caller:TBeat, event:TEvent)

	If MilliSecs() > TITLE_TIMER Then TITLE_ALPHA:*0.99

End Function



' ------------------------------------------------------------------------------------------------
' Draw System Title infos with a blip sound
' ------------------------------------------------------------------------------------------------
Function DrawBlip(Caller:TBeat, event:TEvent)

	If TITLE_TEXT And MilliSecs() > initializing + 500 Then

		If TITLE_DIGITS < Len(TITLE_TEXT) Then
	
			TITLE_DIGITS:+1
			TITLE_OUTPUT = Upper(Left(TITLE_TEXT, TITLE_DIGITS))
			
			Local c:Int = Asc(Right(TITLE_OUTPUT, 1))
			
			SetChannelRate(TITLE_CHANNEL, 2.0)
			
			If c <> 32 Then
			
				If TSound(MEDIA.GetSound("BLIP")) Then
					
					TITLE_CHANNEL = CueSound(MEDIA.GetSound("BLIP"))
					TITLE_CHANNEL.SetVolume(1.0 / 16 * Rnd(0.9, 1.1))
					TITLE_CHANNEL.SetRate(2.0*rnd(0.995,1.005))
					ResumeChannel TITLE_CHANNEL
				
				Else
				
					StopChannel TITLE_CHANNEL
				
				End If

			EndIf
					
		EndIf
		
	EndIf
				
End Function



' ------------------------------------------------------------------------------------------------
' FRAPS style FPS display
' ------------------------------------------------------------------------------------------------
Function DrawFPS()

	Font("FPS")
	SetColor(255, 255, 0)
	SetAlpha(1.0)
	SetBlend LIGHTBLEND
	SetScale(1.0, 1.0)
	DrawText FPS.FPS, SCREEN_WIDTH - (TextWidth(FPS.FPS)), 3
	SetScale(1.0, 1.0)

End Function



' ------------------------------------------------------------------------------------------------
' Title output
' ------------------------------------------------------------------------------------------------
Function Titleoutput()

	Local t:String = LOCALE.Get("GAME_TITLE")'PROJECT_TITLE
	Local w:Int = TextWidth(t) * scaler
	Local h:Int = TextHeight(t) * scaler
	
	SetAlpha(0.2)
	
	' Shadow
	SetColor 0, 0, 0
	DrawText t, (SCREEN_WIDTH / 2.0) - w / 2.0 + (3 * Scaler), (SCREEN_HEIGHT / 2.0) - h / 2.0 + (3 * Scaler)

	' Title
	SetColor 255, 255, 255
	DrawText t, (SCREEN_WIDTH / 2.0) - w / 2.0, (SCREEN_HEIGHT / 2.0) - h / 2.0

	SetScale(Scaler * 0.5, Scaler * 0.5)
	
	t = "www.extrasolar.de"
	w = TextWidth(t) * Scaler / 2
	h = TextHeight(t) * Scaler / 2
	DrawText t, (SCREEN_WIDTH / 2.0) - w / 2.0, (SCREEN_HEIGHT / 1.6) - h / 2.0
	
	SetScale(Scaler, Scaler)
	SetAlpha(1.0)

End Function



' ------------------------------------------------------------------------------------------------
' Information output
' ------------------------------------------------------------------------------------------------
Function SystemInfo()

	info.Scale = (MEDIA.GetOption("SMALL") * Scaler) + (8 * Scaler)
	info.RGB = [0, 255, 0]
	info.Shadow = True
	info.offset = 3 * Scaler

	If info.offset < 1 Then info.offset = 1
	
	Local dist:Double = EntityDistance(CAMERA.CAM, StarMesh) - STARSCALE
	Local temp:Double = System.CalcTemperatureAt(dist)
	Local escape:Double = System.CalcEscapeVelocity(dist)
	Local neardist:Double = 100 - (1.0 / NEARESTDIST * 100)
	Local radiation:Double = 1.0 / dist * Exp(100.0 / System.PeakRadiation) * System.Luminance
		
	If NEAREST.id = 0 Then neardist = NEARESTDIST - STARSCALE
	neardist = LimitFloat(neardist, 0, 100)
		
	Local masslock:Float = 1000 - PLAYER_SPEEDMULTIPLICATOR
	If masslock < 0 Then masslock = 0
	
	If System.SpectralType = "W" Then
	
		escape = escape * Sqr(1.0 / dist) * 10
		temp = temp * Sqr(1.0 / dist)
		radiation = 1.0 / dist * Exp(10.0 / System.PeakRadiation) * System.TemperatureEstimated / 10.0
		
		If gammahit Then
		
			radiation:*10
			CHANNEL_JET = CueSound(MEDIA.GetSound("JETHIT"))
			CHANNEL_JET.SetVolume(1.0 / 16 * Rnd(0.9, 1.1))
			CHANNEL_JET.SetRate(2.0 * Rnd(0.995, 1.005))
			ResumeChannel CHANNEL_JET
			
		EndIf
	
	EndIf
	
	CHANNEL_RADIATION.SetVolume(LimitFloat(Normalize(radiation, 0, 100, 0.0, 0.125), 0.0, 0.125))
	CHANNEL_RADIATION.SetRate(Rnd(0.995, 1.005) * LimitFloat(Normalize(radiation, 0, 100, 0.9, 1.1), 0.9, 1.1))
	
	If (Not ChannelPlaying(CHANNEL_RADIATION)) Then
	
		CHANNEL_RADIATION = CueSound(MEDIA.GetSound("RADIATION"))
	 	ResumeChannel CHANNEL_RADIATION
						
	EndIf
			
	info.Add(FillSpaces(LOCALE.Get("SOLAR_DISTANCE")) + ": " + Round(dist * 1000000 / System.AstronomicalUnitKM, 6) + " AU")
	info.Add(FillSpaces(LOCALE.Get("SOLAR_TEMPERATURE")) + ": " + Round(temp, 1) + "°C")
	info.Add(FillSpaces("Star Gravitation:") + ": " + Round(escape, 1) + "m/s")
	info.Add(FillSpaces("Star Radiation:") + ": " + Round(radiation, 1) + "%")
	info.Add(FillSpaces("Mass Lock (" + NEARESTNAME + "):") + ": " + Round(masslock / 10.0, 3) + "%")
	info.Add(FillSpaces("Distance to " + NEARESTNAME) + ": " + Round(neardist, 1) + "%")
	info.Add(FillSpaces(LOCALE.Get("INFO_CURRENTSPEED")) + ": " + Round(CAMERA.currentspeed * 100, 1) + "%")
					
	info.Add(FillSpaces(LOCALE.Get("INFO_CAMERAPOSITION")) + ": " + Round(CAMERA.x, 3) + " | " + Round(CAMERA.y, 3) + " | " + Round(CAMERA.z, 3))
	'info.Add(FillSpaces(LOCALE.Get("INFO_RGBA")) + ": " + KR + "," + KG + "," + KB + " | " + (KA1 / 255.0) + "," + (KA2 / 255.0))
		
	' bars color gradient
	RestoreData temp
	GRADIENT.generate

	' Bar: Distance to Star
	Local stardistnorm:Double = LimitFloat(Normalize(dist, 0, maxdist, 0, 1), 0, 1)
	Local stardistcol:Int = stardistnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (7 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[stardistcol], GRADIENT.G[stardistcol], GRADIENT.B[stardistcol])
	DrawRect(900 * Scaler, 7 * Scaler, LimitInt(stardistnorm * 360, 0, 360), 30)
	
	' Bar: Temperature
	Local tempnorm:Double = LimitFloat(Normalize(temp, -System.CelsiusKelvin, 2500, 0, 1), 0, 1)
	Local tempcol:Int = tempnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (54 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[tempcol], GRADIENT.G[tempcol], GRADIENT.B[tempcol])
	DrawRect(900 * Scaler, 54 * Scaler, LimitInt(tempnorm * 360, 0, 360), 30)

	' Bar: Gravity
	Local gravnorm:Double = LimitFloat(Normalize(escape, 0, 2000, 0, 1), 0, 1)
	Local gravcol:Int = gravnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (101 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[gravcol], GRADIENT.G[gravcol], GRADIENT.B[gravcol])
	DrawRect(900 * Scaler, 101 * Scaler, LimitInt(gravnorm * 360, 0, 360), 30)

	' Bar: Radiation
	Local radnorm:Double = LimitFloat(Normalize(radiation, 0, 100, 0, 1), 0, 1)
	Local radcol:Int = gravnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (148 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[radcol], GRADIENT.G[radcol], GRADIENT.B[radcol])
	DrawRect(900 * Scaler, 148 * Scaler, LimitInt(radnorm * 360, 0, 360), 30)
	
	' Bar: Masslock
	Local massnorm:Double = LimitFloat(Normalize(masslock, 0, 1000, 0, 1), 0, 1)
	Local masscol:Int = massnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (195 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[masscol], GRADIENT.G[masscol], GRADIENT.B[masscol])
	DrawRect(900 * Scaler, 195 * Scaler, LimitInt(massnorm * 360, 0, 360), 30)

	' Bar: Distance to closest object
	Local distnorm:Double = LimitFloat(Normalize(100 - neardist, 0, 100, 0, 1), 0, 1)
	Local distcol:Int = distnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (242 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[distcol], GRADIENT.G[distcol], GRADIENT.B[distcol])
	DrawRect(900 * Scaler, 242 * Scaler, LimitInt(distnorm * 360, 0, 360), 30)

	' Bar: Current Ship Speed
	Local currentnorm:Double = LimitFloat(Normalize(Abs(CAMERA.currentspeed), 0, 1, 0, 1), 0, 1)
	Local currentcol:Int = currentnorm * 65535
	SetColor(64, 64, 64)
	DrawRect(900 * Scaler - 1, (289 * Scaler) - 1, 360 + 2, 30 + 2)
	SetColor(GRADIENT.R[currentcol], GRADIENT.G[currentcol], GRADIENT.B[currentcol])
	DrawRect(900 * Scaler, 289 * Scaler, LimitInt(currentnorm * 360, 0, 360), 30)
		
	If FLAG.Get("FONT") Then
	
		info.Add("abcdefghijklmnopqrstuvwxyz")
		info.Add("ABCDEFGHIJKLMNOPQRSTUVWXYZ")
		info.Add("0123456789ÄäÖöÜüß!" + Chr(34) + "$%&/()=")
		info.Add("`´*+'#,;.:-_<>²³@€|")
		
	EndIf

	info.Update()

End Function