' ------------------------------------------------------------------------------------------------
' Simple Config file handling
' ------------------------------------------------------------------------------------------------
Type TConfig

	Global config:TMap = CreateMap()
	
	Global List:TList = CreateList()

	' add a new entry
	Method New()

		ListAddLast(List, Self)

	End Method
	
	' load a new line
	Method Load(s:TStream)
			
		While Not Eof(s)
		
			Local l:String = ReadLine(s)
						
			Local d:Int = Instr(l, "=")
			Local k:String = Lower(Left(l, d - 1))
			Local v:String = Mid(l, d + 1, Len(l))
									
			MapInsert(config, k, v)
			
		Wend
			
	End Method
	
	' get a config entry by name
	Function Get:String(Key:String)
		
		Return String(MapValueForKey(config, Lower(Key)))
	
	End Function

End Type