' ------------------------------------------------------------------------------------------------
' Advanced Text Info output
' ------------------------------------------------------------------------------------------------
Type TInfo



	Field Scale:Int = 16								' line height
	Field lineoffset:Int = 0							' line offset
	Field rgb:Int[] = [255, 255, 255]					' text color
	Field sha:Int[] = [0, 0, 0]							' shadow color
	Field shadow:Int = False							' shadow flag
	Field offset:Int = 1								' shadow offset
	Field output:String									' text output

	Global list:TList = CreateList()



	' --------------------------------------------------------------------------------------------
	' METHOD: Create new Object in TList
	' --------------------------------------------------------------------------------------------
	Method New()

		ListAddLast(list, Self)

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Remove Object from TList
	' --------------------------------------------------------------------------------------------
	Method Remove()

		ListRemove(list, Self)

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Add Text line
	' --------------------------------------------------------------------------------------------
	Method Add(output:String, lineoffset:Int = 0)

		Local i:TInfo = New TInfo
		i.output = output
		i.lineoffset = lineoffset

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Output Text
	' --------------------------------------------------------------------------------------------
	Method Update()

		Local cnt:Int = 0

		For Local i:TInfo = EachIn TInfo.list

			If i.output Then

				cnt:+i.lineoffset

				' shadow text first
				If shadow Then

					SetColor sha[0], sha[1], sha[2]
					DrawText i.output, offset, cnt + offset

				EndIf

				' normal text
				SetColor rgb[0], rgb[1], rgb[2]
				DrawText i.output, 0, cnt

				cnt:+Scale

			EndIf

			' remove line from list = clear
			i.Remove()

		Next

	End Method



End Type