Type TLocale

	Global Locale:TMap = CreateMap()			' Global TMap with all text
	
	Field language:String = "EN"				' the current locale Flag
	field path:String=""						' the path to the database
	Field database:String = "locale"			' the database file name
	
	Global db:TDBConnection
	Global q:TDatabaseQuery
	
	Method reset()
	
		LOCALE = Null
		LOCALE = CreateMap()
	
	End Method

	' ------------------------------------------------------------------------------------------------
	' Returns Locale Object
	' ------------------------------------------------------------------------------------------------
	Method Load()
			
		db = LoadDatabase("SQLITE", path + database + ".db")
		If Not db Then db.close()
		
		q = db.executeQuery("SELECT * from locale")
	
		While q.nextRow()

			' get record
			Local r:TQueryRecord = q.rowRecord()
			Local cat:String = r.getStringByName("category")
			Local Key:String = r.getStringByName("key")
			
			MapInsert(LOCALE, cat + "_" + Key, r.getStringByName(language))
									
		Wend

		If db Then
		
			LogUpdate(Get("LOG_LOCALIZATIONDATABASE") + " '" + language + "' " + Get("LOG_LOADED"))
			
		Else
		
			LogUpdate(Get("LOG_LOCALIZATIONERROR"))
		
		EndIf
		
		db.close()
						
	End Method

	' ------------------------------------------------------------------------------------------------
	' Returns Locale Object
	' ------------------------------------------------------------------------------------------------
	Method Get:String(Key:String)
	
		Return String(MapValueForKey(LOCALE, Key))
			
	End Method

End Type