Const BUTTONLOCKED:Int = 2
Const BUTTONPRESSED:Int = 1
Const BUTTONFREE:Int = 0

Const REPEATTIME:Int = 250 'in milliseconds

Global mouse:TMouse = New Tmouse

Function MyHook:Object(id:Int, data:Object, context:Object)

	mouse.Load()

End Function

'Add our hook to the system
AddHook FlipHook, MyHook

Type TButton
	
	Field activated:Int
	Field inuse:Int
	Field free:Int
End Type

Type TMouse


	Field x:Int,  ..
					y:Int,  ..
		Pressed:Int[3],  ..
		DoublePressed:Int[3],  ..
		MouseWheel:Int
	
	Field oldx:Int,  ..
				oldy:Int,  ..
		oldpressed:Int[3],  ..
		oldmousewheel:Int

	Field turnDifference:Int,  ..
		selected:Int
	
	Field State:Int[3],  ..
		ClickCount:Int[3],  ..
		endtime:Long[3]

	' loads all of the mouse processes such as 
	' mouse x, y, z, buttons and click, double, double click.
	' mouse pressed, used and released.
	' needs be called at the beginning of each frame.

	Method Load()
		oldx = x
		oldy = y
		oldmousewheel = MouseWheel
		
		x = MouseX()
		y = MouseY()
		MouseWheel = MouseZ()
		
		turnDifference = MouseWheel - oldMouseWheel

		For Local b:Int = 0 To 2
			
			oldpressed[b] = pressed[b]
			pressed[b] = MouseDown(b + 1)
			
			If oldpressed[b]
			
				If pressed[b]
					State[b] = BUTTONLOCKED
				Else
					State[b] = BUTTONFREE
				EndIf
			
			ElseIf pressed[b]
			
				State[b] = BUTTONPRESSED
			
			EndIf
		
			DoublePressed[b] = False
		
			If State[b] = BUTTONPRESSED
			
				If ClickCount[b] = 0
			
					ClickCount[b] = 1 'first click
					endtime[b] = MilliSecs() + REPEATTIME
			
				Else'second click
			
					If MilliSecs() < endtime[b]
						DoublePressed[b] = True
					EndIf
					ClickCount[b] = 0
			
				EndIf
			ElseIf MilliSecs() > Endtime[b]
			
				ClickCount[b] = 0
			
			EndIf
		Next
	End Method
	' checks if mouse cursor is with in a specified area
	' h = start x
	' v = start y
	' width of area
	' height of area
	' returns true if in area false if not	

	Method InArea:Int(h:Int, v:Int, width:Int, Height:Int)

		If x < h Return False
		If x > (h + width) Return False
		If y < v Return False
		If y > (v + Height) Return False
		Return True

	End Method
	
	' returns mouse x and y position
	' through input variables a and d.

	Method GetXY(a:Int Var, d:Int Var)

		a = Self.x
		d = Self.y

	End Method
	
	'returns true if a mouse "double click" was completed with in current cycle frame. 	

	Method doubleclick:Int(selected:Int = 1)
		selected:-1
		selected:&3
		
		Return DoublePressed[selected]

	End Method
	
	' returns true if a specified mouse button is still pressed based on previos frame.
	
	Method ButtonInUse:Int(selected:Int = 1)
		selected:-1
		selected:&3

		If State[selected] = BUTTONLOCKED
			Return True
		EndIf
		Return False

	End Method
	
	' returns true if the pre-specified mouse button was pressed on current frame.
	
	Method ButtonActivated:Int(selected:Int = 1)
		selected:-1
		selected:&3

		If State[selected] = BUTTONPRESSED
			Return True
		EndIf
		Return False

	End Method
	
	'returns true if a pre-specified buttone is currently released
	
	Method ButtonReleased:Int(selected:Int = 1)
		selected:-1
		selected:&3
		
		If State[selected] = BUTTONFREE
			Return True
		EndIf
		Return False

	End Method
	
	'return true if the mouse button was moved based on previos frame and current frame.
	
	Method moved:Int()

		If oldx <> x Return True
		If oldy <> y Return True
		Return False

	End Method
	
	' same as above but for x only
	
	Method MovedX:Int()

		If oldx <> x Return True
		Return False

	End Method
	
	' same as above but for y only
	
	Method movedy:Int()

		If oldy <> y Return True
		Return False

	End Method
	
	' returns mouse speed(difference between current frame x and previous frame x
	
	Method Thrustx:Int()

		Return x - oldx

	End Method
	
	' returns mouse speed(difference Between Current Frame y And previous Frame y
	
	Method Thrusty:Int()

		Return y - oldy

	End Method
	
	' returns mouse wheel speed based on Current Frame And prvious Frame Position.
	
	Method wheelThrust:Int()

		Return TurnDifference

	End Method

End Type