#include <openb3d.mod/ddsloader.mod/.bmx/ddsloader.bmx.release.win32.x86.h>
struct BBString_2{BBClass_String* clas;BBULONG hash;int length;BBChar buf[2];};
struct BBString_15{BBClass_String* clas;BBULONG hash;int length;BBChar buf[15];};
struct BBString_38{BBClass_String* clas;BBULONG hash;int length;BBChar buf[38];};
struct BBString_25{BBClass_String* clas;BBULONG hash;int length;BBChar buf[25];};
struct BBString_9{BBClass_String* clas;BBULONG hash;int length;BBChar buf[9];};
struct BBString_13{BBClass_String* clas;BBULONG hash;int length;BBChar buf[13];};
struct BBString_17{BBClass_String* clas;BBULONG hash;int length;BBChar buf[17];};
struct BBString_8{BBClass_String* clas;BBULONG hash;int length;BBChar buf[8];};
struct BBString_12{BBClass_String* clas;BBULONG hash;int length;BBChar buf[12];};
struct BBString_6{BBClass_String* clas;BBULONG hash;int length;BBChar buf[6];};
struct BBString_10{BBClass_String* clas;BBULONG hash;int length;BBChar buf[10];};
struct BBString_14{BBClass_String* clas;BBULONG hash;int length;BBChar buf[14];};
struct BBString_18{BBClass_String* clas;BBULONG hash;int length;BBChar buf[18];};
struct BBString_7{BBClass_String* clas;BBULONG hash;int length;BBChar buf[7];};
struct BBString_11{BBClass_String* clas;BBULONG hash;int length;BBChar buf[11];};
static struct BBString_2 _s2={
	&bbStringClass,
	0xd080db24ebb0e205,
	2,
	{32,32}
};
static struct BBString_15 _s3={
	&bbStringClass,
	0xae280b9b50c2ae3a,
	15,
	{32,68,68,83,32,105,110,115,116,97,110,99,101,58,32}
};
static struct BBString_38 _s1={
	&bbStringClass,
	0x545127d9e0c1e898,
	38,
	{32,77,97,120,50,100,32,110,111,116,32,99,111,109,112,114,101
	,115,115,101,100,32,116,101,120,116,117,114,101,115,32,118,101
	,114,115,105,111,110}
};
static struct BBString_25 _s0={
	&bbStringClass,
	0xf4490c625a8e770d,
	25,
	{32,78,111,32,112,105,120,109,97,112,32,105,109,97,103,101,32
	,108,111,97,100,101,100,58,32}
};
static struct BBString_9 _s4={
	&bbStringClass,
	0x1d057fd34d86b0a9,
	9,
	{32,98,117,102,102,101,114,58,32}
};
static struct BBString_13 _s5={
	&bbStringClass,
	0xa94f21246012c9c3,
	13,
	{32,98,117,102,102,101,114,58,32,78,117,108,108}
};
static struct BBString_13 _s22={
	&bbStringClass,
	0xf0a56f4af279e018,
	13,
	{32,99,111,109,112,111,110,101,110,116,115,58,32}
};
static struct BBString_17 _s23={
	&bbStringClass,
	0x9b23fd3bce630308,
	17,
	{32,99,111,109,112,111,110,101,110,116,115,58,32,78,117,108,108
}
};
static struct BBString_8 _s12={
	&bbStringClass,
	0x47ee8d984e9968c,
	8,
	{32,100,101,112,116,104,58,32}
};
static struct BBString_12 _s13={
	&bbStringClass,
	0x437372f5aff13d86,
	12,
	{32,100,101,112,116,104,58,32,78,117,108,108}
};
static struct BBString_6 _s6={
	&bbStringClass,
	0x558a9a9299e22ae1,
	6,
	{32,100,120,116,58,32}
};
static struct BBString_10 _s7={
	&bbStringClass,
	0x6961dde11a423cd6,
	10,
	{32,100,120,116,58,32,78,117,108,108}
};
static struct BBString_9 _s20={
	&bbStringClass,
	0xcb2fb643e3598fd3,
	9,
	{32,102,111,114,109,97,116,58,32}
};
static struct BBString_13 _s21={
	&bbStringClass,
	0x5f2c27721097402c,
	13,
	{32,102,111,114,109,97,116,58,32,78,117,108,108}
};
static struct BBString_9 _s10={
	&bbStringClass,
	0x9a2a1bd266a67e9e,
	9,
	{32,104,101,105,103,104,116,58,32}
};
static struct BBString_13 _s11={
	&bbStringClass,
	0xd438dfaa662b8939,
	13,
	{32,104,101,105,103,104,116,58,32,78,117,108,108}
};
static struct BBString_14 _s14={
	&bbStringClass,
	0xe9e20e05c0e44abc,
	14,
	{32,109,105,112,109,97,112,99,111,117,110,116,58,32}
};
static struct BBString_18 _s15={
	&bbStringClass,
	0x86ac4e6b17ab6e82,
	18,
	{32,109,105,112,109,97,112,99,111,117,110,116,58,32,78,117,108
	,108}
};
static struct BBString_8 _s16={
	&bbStringClass,
	0xe7a6809462b943a6,
	8,
	{32,112,105,116,99,104,58,32}
};
static struct BBString_12 _s17={
	&bbStringClass,
	0xdb0121302a991c68,
	12,
	{32,112,105,116,99,104,58,32,78,117,108,108}
};
static struct BBString_7 _s18={
	&bbStringClass,
	0x9a89c1ded579ac26,
	7,
	{32,115,105,122,101,58,32}
};
static struct BBString_11 _s19={
	&bbStringClass,
	0x1b5a053d0aacf8b,
	11,
	{32,115,105,122,101,58,32,78,117,108,108}
};
static struct BBString_9 _s24={
	&bbStringClass,
	0x825655db7a2d2c94,
	9,
	{32,116,97,114,103,101,116,58,32}
};
static struct BBString_13 _s25={
	&bbStringClass,
	0x6c749337fe23334e,
	13,
	{32,116,97,114,103,101,116,58,32,78,117,108,108}
};
static struct BBString_8 _s8={
	&bbStringClass,
	0x5bcf81ddbebe12a0,
	8,
	{32,119,105,100,116,104,58,32}
};
static struct BBString_12 _s9={
	&bbStringClass,
	0x58a79411f9ae208f,
	12,
	{32,119,105,100,116,104,58,32,78,117,108,108}
};
struct BBDebugScope_2{int kind; const char *name; BBDebugDecl decls[3]; };
struct BBDebugScope_34{int kind; const char *name; BBDebugDecl decls[35]; };
void _openb3d_ddsloader_TPixmapLoaderDDS_New(struct openb3d_ddsloader_TPixmapLoaderDDS_obj* o) {
	_brl_pixmap_TPixmapLoader_New((struct brl_pixmap_TPixmapLoader_obj*)o);
	o->clas = &openb3d_ddsloader_TPixmapLoaderDDS;
}
struct brl_pixmap_TPixmap_obj* _openb3d_ddsloader_TPixmapLoaderDDS_LoadPixmap_TTStream(struct openb3d_ddsloader_TPixmapLoaderDDS_obj* o,struct brl_stream_TStream_obj* bbt_stream){
	BBSIZET bbt_bufLen=((BBSIZET)brl_stream_StreamSize((struct brl_stream_TStream_obj*)bbt_stream));
	BBBYTE* bbt_buffer=bbMemAlloc((size_t)bbt_bufLen);
	struct brl_ramstream_TRamStream_obj* bbt_ram=(struct brl_ramstream_TRamStream_obj*)brl_ramstream_CreateRamStream(bbt_buffer,((BBLONG)bbt_bufLen),1,1);
	brl_stream_CopyStream((struct brl_stream_TStream_obj*)bbt_stream,(struct brl_stream_TStream_obj*)((struct brl_stream_TStream_obj*)bbObjectDowncast((BBOBJECT)bbt_ram,(BBClass*)&brl_stream_TStream)),4096);
	struct brl_pixmap_TPixmap_obj* bbt_pixmap=(struct brl_pixmap_TPixmap_obj*)((struct brl_pixmap_TPixmap_obj*)&bbNullObject);
	BBBYTE* bbt_imgPtr=0;
	BBINT bbt_width=0;
	BBINT bbt_height=0;
	BBINT bbt_channels=0;
	BBSTRING bbt_file=((BBString*)&bbEmptyString);
	BBBYTE* bbt_cString=bbStringToCString((BBSTRING)bbt_file);
	bbt_imgPtr=DDSLoadSurface_(bbt_cString,0,bbt_buffer,bbt_bufLen);
	bbMemFree((void*)bbt_cString);
	if(bbt_imgPtr){
		struct openb3d_ddsloader_TDDS_obj* bbt_dds=(struct openb3d_ddsloader_TDDS_obj*)openb3d_ddsloader_TDDS_CreateObject_TTDDS_pb(bbt_imgPtr);
		brl_linkedlist_ListAddLast((struct brl_linkedlist_TList_obj*)openb3d_ddsloader_TDDS_dds_list,(BBOBJECT)bbt_dds);
		bbt_channels=bbt_dds->_openb3d_ddsloader_tdds_components [0];
		bbt_width=bbt_dds->_openb3d_ddsloader_tdds_width [0];
		bbt_height=bbt_dds->_openb3d_ddsloader_tdds_height [0];
		BBINT bbt_pf=0;
		BBINT bbt_=bbt_channels;
		if(bbt_==3){
			bbt_pf=4;
		}else{
			if(bbt_==4){
				bbt_pf=6;
			}
		}
		if(bbt_pf!=0){
			bbt_pixmap=(struct brl_pixmap_TPixmap_obj*)brl_pixmap_CreatePixmap(bbt_width,bbt_height,bbt_pf,((BBINT*)BBARRAYDATA(brl_pixmap_pixel_BytesPerPixel,1))[((BBUINT)bbt_pf)]);
			DDSCopyRect_(bbt_dds->_openb3d_ddsloader_tdds_dxt ,bbt_dds->_openb3d_ddsloader_tdds_width [0],bbt_dds->_openb3d_ddsloader_tdds_height [0],0,0,bbt_pixmap->_brl_pixmap_tpixmap_pixels ,bbt_dds->_openb3d_ddsloader_tdds_width [0],bbt_dds->_openb3d_ddsloader_tdds_height [0],bbt_dds->_openb3d_ddsloader_tdds_components [0],0,bbt_dds->_openb3d_ddsloader_tdds_format [0]);
			bbt_dds->_openb3d_ddsloader_tdds_pixmap =(struct brl_pixmap_TPixmap_obj*)bbt_pixmap;
		}
		brl_stream_CloseStream((struct brl_stream_TStream_obj*)((struct brl_stream_TStream_obj*)bbObjectDowncast((BBOBJECT)bbt_ram,(BBClass*)&brl_stream_TStream)));
		bbt_dds->_openb3d_ddsloader_tdds_bmx_buffer =bbt_buffer;
	}
	return (struct brl_pixmap_TPixmap_obj*)bbt_pixmap;
}
struct BBDebugScope_2 openb3d_ddsloader_TPixmapLoaderDDS_scope ={
	BBDEBUGSCOPE_USERTYPE,
	"TPixmapLoaderDDS",
	{
		{
			BBDEBUGDECL_TYPEMETHOD,
			"New",
			"()",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TPixmapLoaderDDS_New
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"LoadPixmap",
			"(:TStream):TPixmap",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TPixmapLoaderDDS_LoadPixmap_TTStream
		},
		{
			BBDEBUGDECL_END
		}
	}
};
struct BBClass_openb3d_ddsloader_TPixmapLoaderDDS openb3d_ddsloader_TPixmapLoaderDDS={
	&brl_pixmap_TPixmapLoader,
	bbObjectFree,
	(BBDebugScope*)&openb3d_ddsloader_TPixmapLoaderDDS_scope,
	sizeof(struct openb3d_ddsloader_TPixmapLoaderDDS_obj),
	(void (*)(BBOBJECT))_openb3d_ddsloader_TPixmapLoaderDDS_New,
	bbObjectDtor,
	bbObjectToString,
	bbObjectCompare,
	bbObjectSendMessage,
	0,
	0,
	0
	,0
	,sizeof(void*)
	,_openb3d_ddsloader_TPixmapLoaderDDS_LoadPixmap_TTStream
};

void _openb3d_ddsloader_TDDS_New(struct openb3d_ddsloader_TDDS_obj* o) {
	bbObjectCtor((BBOBJECT)o);
	o->clas = &openb3d_ddsloader_TDDS;
	o->_openb3d_ddsloader_tdds_buffer = 0;
	o->_openb3d_ddsloader_tdds_mipmaps = bbArrayNew1D(":TDDS", 1);
	o->_openb3d_ddsloader_tdds_width = 0;
	o->_openb3d_ddsloader_tdds_height = 0;
	o->_openb3d_ddsloader_tdds_depth = 0;
	o->_openb3d_ddsloader_tdds_mipmapcount = 0;
	o->_openb3d_ddsloader_tdds_pitch = 0;
	o->_openb3d_ddsloader_tdds_size = 0;
	o->_openb3d_ddsloader_tdds_dxt = 0;
	o->_openb3d_ddsloader_tdds_format = 0;
	o->_openb3d_ddsloader_tdds_components = 0;
	o->_openb3d_ddsloader_tdds_target = 0;
	o->_openb3d_ddsloader_tdds_pixmap = (struct brl_pixmap_TPixmap_obj*)((struct brl_pixmap_TPixmap_obj*)&bbNullObject);
	o->_openb3d_ddsloader_tdds_bmx_buffer = 0;
	o->_openb3d_ddsloader_tdds_instance = 0;
	o->_openb3d_ddsloader_tdds_exists = 0;
}
struct openb3d_ddsloader_TDDS_obj* openb3d_ddsloader_TDDS_CreateObject_TTDDS_pb(BBBYTE* bbt_inst){
	if(bbt_inst==0){
		return (struct openb3d_ddsloader_TDDS_obj*)&bbNullObject;
	}
	struct openb3d_ddsloader_TDDS_obj* bbt_obj=(struct openb3d_ddsloader_TDDS_obj*)(struct openb3d_ddsloader_TDDS_obj*)bbObjectNew((BBClass *)&openb3d_ddsloader_TDDS);
	(openb3d_ddsloader_TDDS_dds_map)->clas->m_Insert_pbTObject((struct brl_map_ptrmap_TPtrMap_obj*)openb3d_ddsloader_TDDS_dds_map,bbt_inst,(BBOBJECT)bbt_obj);
	bbt_obj->_openb3d_ddsloader_tdds_instance =bbt_inst;
	(bbt_obj)->clas->m_InitFields((struct openb3d_ddsloader_TDDS_obj*)bbt_obj);
	return (struct openb3d_ddsloader_TDDS_obj*)bbt_obj;
}
void openb3d_ddsloader_TDDS_FreeObject_v_pb(BBBYTE* bbt_inst){
	(openb3d_ddsloader_TDDS_dds_map)->clas->m_Remove_pb((struct brl_map_ptrmap_TPtrMap_obj*)openb3d_ddsloader_TDDS_dds_map,bbt_inst);
}
struct openb3d_ddsloader_TDDS_obj* openb3d_ddsloader_TDDS_GetObject_TTDDS_pb(BBBYTE* bbt_inst){
	return (struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj*)bbObjectDowncast((BBOBJECT)(openb3d_ddsloader_TDDS_dds_map)->clas->m_ValueForKey_pb((struct brl_map_ptrmap_TPtrMap_obj*)openb3d_ddsloader_TDDS_dds_map,bbt_inst),(BBClass*)&openb3d_ddsloader_TDDS));
}
BBBYTE* openb3d_ddsloader_TDDS_GetInstance_pb_TTDDS(struct openb3d_ddsloader_TDDS_obj* bbt_obj){
	if(((BBOBJECT)bbt_obj)==&bbNullObject){
		return 0;
	}
	return bbt_obj->_openb3d_ddsloader_tdds_instance ;
}
void _openb3d_ddsloader_TDDS_InitFields(struct openb3d_ddsloader_TDDS_obj* o){
	o->_openb3d_ddsloader_tdds_buffer =DirectDrawSurfaceUChar_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),1);
	o->_openb3d_ddsloader_tdds_dxt =DirectDrawSurfaceUChar_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),9);
	o->_openb3d_ddsloader_tdds_width =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),3);
	o->_openb3d_ddsloader_tdds_height =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),4);
	o->_openb3d_ddsloader_tdds_depth =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),5);
	o->_openb3d_ddsloader_tdds_mipmapcount =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),6);
	o->_openb3d_ddsloader_tdds_pitch =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),7);
	o->_openb3d_ddsloader_tdds_size =DirectDrawSurfaceInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),8);
	o->_openb3d_ddsloader_tdds_format =DirectDrawSurfaceUInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),10);
	o->_openb3d_ddsloader_tdds_components =DirectDrawSurfaceUInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),11);
	o->_openb3d_ddsloader_tdds_target =DirectDrawSurfaceUInt_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),12);
	if(o->_openb3d_ddsloader_tdds_mipmapcount [0]>0){
		o->_openb3d_ddsloader_tdds_mipmaps =bbArraySlice(":TDDS",o->_openb3d_ddsloader_tdds_mipmaps ,0,o->_openb3d_ddsloader_tdds_mipmapcount [0]);
		{
			BBINT bbt_id=0;
			BBINT bbt_=o->_openb3d_ddsloader_tdds_mipmapcount [0];
			for(;(bbt_id<bbt_);bbt_id=(bbt_id+1)){
				BBBYTE* bbt_inst=DirectDrawSurfaceArray_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),2,bbt_id);
				((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_id)]=(struct openb3d_ddsloader_TDDS_obj*)o->clas->f_GetObject_TTDDS_pb(bbt_inst);
				if((((BBOBJECT)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_id)])==&bbNullObject) && (bbt_inst!=0)){
					((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_id)]=(struct openb3d_ddsloader_TDDS_obj*)o->clas->f_CreateObject_TTDDS_pb(bbt_inst);
				}
			}
		}
	}
	o->_openb3d_ddsloader_tdds_exists =1;
}
BBSTRING openb3d_ddsloader_TDDS_StringPtr_S_pb(BBBYTE* bbt_inst){
	return bbStringFromSizet(bbt_inst);
}
void _openb3d_ddsloader_TDDS_DebugFields_ii(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_debug_subobjects,BBINT bbt_debug_base_types){
	BBSTRING bbt_pad=((BBString*)&bbEmptyString);
	BBINT bbt_loop=bbt_debug_subobjects;
	if(bbt_debug_base_types>bbt_debug_subobjects){
		bbt_loop=bbt_debug_base_types;
	}
	{
		BBINT bbt_i=1;
		BBINT bbt_=bbt_loop;
		for(;(bbt_i<bbt_);bbt_i=(bbt_i+1)){
			bbt_pad=bbStringConcat(bbt_pad,((BBString*)&_s2));
		}
	}
	if(bbt_debug_subobjects!=0){
		bbt_debug_subobjects+=1;
	}
	if(bbt_debug_base_types!=0){
		bbt_debug_base_types+=1;
	}
	brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s3)),o->clas->f_StringPtr_S_pb(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o))));
	if(o->_openb3d_ddsloader_tdds_buffer !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s4)),o->clas->f_StringPtr_S_pb(o->_openb3d_ddsloader_tdds_buffer )));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s5)));
	}
	if(o->_openb3d_ddsloader_tdds_dxt !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s6)),o->clas->f_StringPtr_S_pb(o->_openb3d_ddsloader_tdds_dxt )));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s7)));
	}
	if(o->_openb3d_ddsloader_tdds_width !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s8)),bbStringFromInt(o->_openb3d_ddsloader_tdds_width [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s9)));
	}
	if(o->_openb3d_ddsloader_tdds_height !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s10)),bbStringFromInt(o->_openb3d_ddsloader_tdds_height [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s11)));
	}
	if(o->_openb3d_ddsloader_tdds_depth !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s12)),bbStringFromInt(o->_openb3d_ddsloader_tdds_depth [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s13)));
	}
	if(o->_openb3d_ddsloader_tdds_mipmapcount !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s14)),bbStringFromInt(o->_openb3d_ddsloader_tdds_mipmapcount [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s15)));
	}
	if(o->_openb3d_ddsloader_tdds_pitch !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s16)),bbStringFromInt(o->_openb3d_ddsloader_tdds_pitch [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s17)));
	}
	if(o->_openb3d_ddsloader_tdds_size !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s18)),bbStringFromInt(o->_openb3d_ddsloader_tdds_size [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s19)));
	}
	if(o->_openb3d_ddsloader_tdds_format !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s20)),bbStringFromInt(o->_openb3d_ddsloader_tdds_format [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s21)));
	}
	if(o->_openb3d_ddsloader_tdds_components !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s22)),bbStringFromInt(o->_openb3d_ddsloader_tdds_components [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s23)));
	}
	if(o->_openb3d_ddsloader_tdds_target !=0){
		brl_blitz_DebugLog(bbStringConcat(bbStringConcat(bbt_pad,((BBString*)&_s24)),bbStringFromInt(o->_openb3d_ddsloader_tdds_target [0])));
	}else{
		brl_blitz_DebugLog(bbStringConcat(bbt_pad,((BBString*)&_s25)));
	}
	brl_blitz_DebugLog((BBString*)&bbEmptyString);
}
void _openb3d_ddsloader_TDDS_FreeDDS(struct openb3d_ddsloader_TDDS_obj* o){
	if(o->_openb3d_ddsloader_tdds_exists !=0){
		o->_openb3d_ddsloader_tdds_exists =0;
		((BBINT*)BBARRAYDATA(brl_pixmap_pixel_GreenBitsPerPixel,1))[0U]=0;
		((BBINT*)BBARRAYDATA(brl_pixmap_pixel_BlueBitsPerPixel,1))[0U]=0;
		brl_linkedlist_ListRemove((struct brl_linkedlist_TList_obj*)openb3d_ddsloader_TDDS_dds_list,(BBOBJECT)o);
		DDSFreeDirectDrawSurface_(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o),0);
		if(((o->_openb3d_ddsloader_tdds_bmx_buffer !=0) && (o->_openb3d_ddsloader_tdds_width [0]>0)) && (o->_openb3d_ddsloader_tdds_height [0]>0)){
			bbMemFree((void*)o->_openb3d_ddsloader_tdds_bmx_buffer );
		}
		{
			BBINT bbt_id=0;
			BBINT bbt_=o->_openb3d_ddsloader_tdds_mipmapcount [0];
			for(;(bbt_id<bbt_);bbt_id=(bbt_id+1)){
				if(((BBOBJECT)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_id)])!=&bbNullObject){
					o->clas->f_FreeObject_v_pb(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_id)]));
				}
			}
		}
		o->clas->f_FreeObject_v_pb(o->clas->f_GetInstance_pb_TTDDS((struct openb3d_ddsloader_TDDS_obj*)o));
	}
}
BBINT _openb3d_ddsloader_TDDS_GetPitch_iii(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_width,BBINT bbt_format,BBINT bbt_components){
	if(((bbt_format==33776) || (bbt_format==33778)) || (bbt_format==33779)){
		BBINT bbt_bpp=0;
		if(bbt_format==33776){
			bbt_bpp=8;
		}else{
			bbt_bpp=16;
		}
		return (((bbt_width+3)/4)*bbt_bpp);
	}
	return (bbt_width*bbt_components);
}
BBINT _openb3d_ddsloader_TDDS_IsCompressed(struct openb3d_ddsloader_TDDS_obj* o){
	if(((o->_openb3d_ddsloader_tdds_format [0]==33776) || (o->_openb3d_ddsloader_tdds_format [0]==33778)) || (o->_openb3d_ddsloader_tdds_format [0]==33779)){
		return 1;
	}
	return 0;
}
void _openb3d_ddsloader_TDDS_ImageParameters_i(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_flags){
	glTexParameteri((GLenum)3553,(GLenum)10242,(GLint)33071);
	glTexParameteri((GLenum)3553,(GLenum)10243,(GLint)33071);
	if(((unsigned int)(bbt_flags)&(unsigned int)(2))!=0){
		glTexParameteri((GLenum)3553,(GLenum)10240,(GLint)9729);
		if(((unsigned int)(bbt_flags)&(unsigned int)(4))!=0){
			glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9987);
		}else{
			glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9729);
		}
	}else{
		glTexParameteri((GLenum)3553,(GLenum)10240,(GLint)9728);
		if(((unsigned int)(bbt_flags)&(unsigned int)(4))!=0){
			glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9984);
		}else{
			glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9728);
		}
	}
}
void _openb3d_ddsloader_TDDS_TextureParameters_i(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_tex_flags){
	if(((unsigned int)(bbt_tex_flags)&(unsigned int)(8))!=0){
		glTexParameteri((GLenum)3553,(GLenum)10240,(GLint)9729);
		glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9987);
	}else{
		glTexParameteri((GLenum)3553,(GLenum)10240,(GLint)9728);
		glTexParameteri((GLenum)3553,(GLenum)10241,(GLint)9728);
	}
	if(((unsigned int)(bbt_tex_flags)&(unsigned int)(16))!=0){
		glTexParameteri((GLenum)3553,(GLenum)10242,(GLint)33071);
	}else{
		glTexParameteri((GLenum)3553,(GLenum)10242,(GLint)10497);
	}
	if(((unsigned int)(bbt_tex_flags)&(unsigned int)(32))!=0){
		glTexParameteri((GLenum)3553,(GLenum)10243,(GLint)33071);
	}else{
		glTexParameteri((GLenum)3553,(GLenum)10243,(GLint)10497);
	}
}
void _openb3d_ddsloader_TDDS_UploadTexture2D_i(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_mipmap_flag){
	BBINT bbt_row=0;
	BBINT bbt_mmc=o->_openb3d_ddsloader_tdds_mipmapcount [0];
	if(o->_openb3d_ddsloader_tdds_mipmapcount [0]>DDSCountMipmaps_(o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_height [0])){
		bbt_mmc=DDSCountMipmaps_(o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_height [0]);
	}
	if(((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_IsCompressed((struct openb3d_ddsloader_TDDS_obj*)o)!=0){
		bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_format [0],0);
		glPixelStorei((GLenum)3314,(GLint)bbt_row);
		__glewCompressedTexImage2D(3553,0,o->_openb3d_ddsloader_tdds_format [0],o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_height [0],0,o->_openb3d_ddsloader_tdds_size [0],o->_openb3d_ddsloader_tdds_dxt );
		{
			BBINT bbt_j=0;
			BBINT bbt_=bbt_mmc;
			for(;(bbt_j<bbt_);bbt_j=(bbt_j+1)){
				struct openb3d_ddsloader_TDDS_obj* bbt_mip=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j)];
				if(((bbt_mip->_openb3d_ddsloader_tdds_width [0]==0) || (bbt_mip->_openb3d_ddsloader_tdds_height [0]==0)) || (bbt_mipmap_flag==0)){
					break;
				}
				bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_mip->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_format [0],0);
				glPixelStorei((GLenum)3314,(GLint)bbt_row);
				__glewCompressedTexImage2D(3553,(bbt_j+1),o->_openb3d_ddsloader_tdds_format [0],bbt_mip->_openb3d_ddsloader_tdds_width [0],bbt_mip->_openb3d_ddsloader_tdds_height [0],0,bbt_mip->_openb3d_ddsloader_tdds_size [0],bbt_mip->_openb3d_ddsloader_tdds_dxt );
			}
		}
	}else{
		glPixelStorei((GLenum)3317,(GLint)o->_openb3d_ddsloader_tdds_components [0]);
		bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_format [0],o->_openb3d_ddsloader_tdds_components [0]);
		glPixelStorei((GLenum)3314,(GLint)(bbt_row/o->_openb3d_ddsloader_tdds_components [0]));
		glTexImage2D((GLenum)3553,(GLint)0,(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)o->_openb3d_ddsloader_tdds_width [0],(GLsizei)o->_openb3d_ddsloader_tdds_height [0],(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)o->_openb3d_ddsloader_tdds_dxt );
		{
			BBINT bbt_j2=0;
			BBINT bbt_2=bbt_mmc;
			for(;(bbt_j2<bbt_2);bbt_j2=(bbt_j2+1)){
				struct openb3d_ddsloader_TDDS_obj* bbt_mip2=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j2)];
				if(((bbt_mip2->_openb3d_ddsloader_tdds_width [0]==0) || (bbt_mip2->_openb3d_ddsloader_tdds_height [0]==0)) || (bbt_mipmap_flag==0)){
					break;
				}
				bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_mip2->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_format [0],o->_openb3d_ddsloader_tdds_components [0]);
				glPixelStorei((GLenum)3314,(GLint)(bbt_row/o->_openb3d_ddsloader_tdds_components [0]));
				glTexImage2D((GLenum)3553,(GLint)(bbt_j2+1),(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)bbt_mip2->_openb3d_ddsloader_tdds_width [0],(GLsizei)bbt_mip2->_openb3d_ddsloader_tdds_height [0],(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)bbt_mip2->_openb3d_ddsloader_tdds_dxt );
			}
		}
	}
	glPixelStorei((GLenum)3314,(GLint)0);
}
void _openb3d_ddsloader_TDDS_UploadTextureSubImage2D_iiiipbiii(struct openb3d_ddsloader_TDDS_obj* o,BBINT bbt_ix,BBINT bbt_iy,BBINT bbt_iwidth,BBINT bbt_iheight,BBBYTE* bbt_pixels,BBINT bbt_mipmap_flag,BBINT bbt_target,BBINT bbt_inv){
	BBINT bbt_mwidth=0;
	BBINT bbt_mheight=0;
	BBINT bbt_row=0;
	BBINT bbt_height4=0;
	BBINT bbt_mmc=o->_openb3d_ddsloader_tdds_mipmapcount [0];
	if(o->_openb3d_ddsloader_tdds_mipmapcount [0]>DDSCountMipmaps_(bbt_iwidth,bbt_iheight)){
		bbt_mmc=DDSCountMipmaps_(bbt_iwidth,bbt_iheight);
	}
	if(((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_IsCompressed((struct openb3d_ddsloader_TDDS_obj*)o)!=0){
		if(bbt_iheight>4){
			bbt_height4=(bbt_iheight/4);
		}else{
			bbt_height4=1;
		}
		bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_iwidth,o->_openb3d_ddsloader_tdds_format [0],0);
		glPixelStorei((GLenum)3314,(GLint)bbt_row);
		DDSCopyRect_(o->_openb3d_ddsloader_tdds_dxt ,o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_height [0],bbt_ix,bbt_iy,bbt_pixels,bbt_iwidth,bbt_iheight,0,bbt_inv,o->_openb3d_ddsloader_tdds_format [0]);
		__glewCompressedTexImage2D(bbt_target,0,o->_openb3d_ddsloader_tdds_format [0],bbt_iwidth,bbt_iheight,0,(bbt_row*bbt_height4),bbt_pixels);
		{
			BBINT bbt_j=0;
			BBINT bbt_=bbt_mmc;
			for(;(bbt_j<bbt_);bbt_j=(bbt_j+1)){
				struct openb3d_ddsloader_TDDS_obj* bbt_mip=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j)];
				BBINT bbt_pow2=((BBINT)bbLongPow(2LL, ((BBLONG)(bbt_j+1))));
				bbt_mwidth=(bbt_iwidth/bbt_pow2);
				bbt_mheight=(bbt_iheight/bbt_pow2);
				if(bbt_mheight>4){
					bbt_height4=(bbt_mheight/4);
				}else{
					bbt_height4=1;
				}
				if(((bbt_mwidth==0) || (bbt_mheight==0)) || (bbt_mipmap_flag==0)){
					break;
				}
				bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_mwidth,o->_openb3d_ddsloader_tdds_format [0],0);
				glPixelStorei((GLenum)3314,(GLint)bbt_row);
				DDSCopyRect_(bbt_mip->_openb3d_ddsloader_tdds_dxt ,bbt_mip->_openb3d_ddsloader_tdds_width [0],bbt_mip->_openb3d_ddsloader_tdds_height [0],(bbt_ix/bbt_pow2),(bbt_iy/bbt_pow2),bbt_pixels,bbt_mwidth,bbt_mheight,0,bbt_inv,o->_openb3d_ddsloader_tdds_format [0]);
				__glewCompressedTexImage2D(bbt_target,(bbt_j+1),o->_openb3d_ddsloader_tdds_format [0],bbt_mwidth,bbt_mheight,0,(bbt_row*bbt_height4),bbt_pixels);
			}
		}
	}else{
		glPixelStorei((GLenum)3317,(GLint)o->_openb3d_ddsloader_tdds_components [0]);
		bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_iwidth,o->_openb3d_ddsloader_tdds_format [0],o->_openb3d_ddsloader_tdds_components [0]);
		glPixelStorei((GLenum)3314,(GLint)(bbt_row/o->_openb3d_ddsloader_tdds_components [0]));
		DDSCopyRect_(o->_openb3d_ddsloader_tdds_dxt ,o->_openb3d_ddsloader_tdds_width [0],o->_openb3d_ddsloader_tdds_height [0],bbt_ix,bbt_iy,bbt_pixels,bbt_iwidth,bbt_iheight,o->_openb3d_ddsloader_tdds_components [0],bbt_inv,o->_openb3d_ddsloader_tdds_format [0]);
		glTexImage2D((GLenum)bbt_target,(GLint)0,(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)bbt_iwidth,(GLsizei)bbt_iheight,(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)bbt_pixels);
		{
			BBINT bbt_j2=0;
			BBINT bbt_2=bbt_mmc;
			for(;(bbt_j2<bbt_2);bbt_j2=(bbt_j2+1)){
				struct openb3d_ddsloader_TDDS_obj* bbt_mip2=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j2)];
				BBINT bbt_pow22=((BBINT)bbLongPow(2LL, ((BBLONG)(bbt_j2+1))));
				bbt_mwidth=(bbt_iwidth/bbt_pow22);
				bbt_mheight=(bbt_iheight/bbt_pow22);
				if(((bbt_mwidth==0) || (bbt_mheight==0)) || (bbt_mipmap_flag==0)){
					break;
				}
				bbt_row=((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_GetPitch_iii((struct openb3d_ddsloader_TDDS_obj*)o,bbt_mwidth,o->_openb3d_ddsloader_tdds_format [0],o->_openb3d_ddsloader_tdds_components [0]);
				glPixelStorei((GLenum)3314,(GLint)(bbt_row/o->_openb3d_ddsloader_tdds_components [0]));
				DDSCopyRect_(bbt_mip2->_openb3d_ddsloader_tdds_dxt ,bbt_mip2->_openb3d_ddsloader_tdds_width [0],bbt_mip2->_openb3d_ddsloader_tdds_height [0],(bbt_ix/bbt_pow22),(bbt_iy/bbt_pow22),bbt_pixels,bbt_mwidth,bbt_mheight,o->_openb3d_ddsloader_tdds_components [0],bbt_inv,o->_openb3d_ddsloader_tdds_format [0]);
				glTexImage2D((GLenum)bbt_target,(GLint)(bbt_j2+1),(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)bbt_mwidth,(GLsizei)bbt_mheight,(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)bbt_pixels);
			}
		}
	}
	glPixelStorei((GLenum)3314,(GLint)0);
}
void _openb3d_ddsloader_TDDS_UploadTextureCubeMap(struct openb3d_ddsloader_TDDS_obj* o){
	{
		BBINT bbt_i=0;
		for(;(bbt_i<=5);bbt_i=(bbt_i+1)){
			BBINT bbt_face=(34069+bbt_i);
			struct openb3d_ddsloader_TDDS_obj* bbt_surf=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(o->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_i)];
			if(((struct openb3d_ddsloader_TDDS_obj*)o)->clas->m_IsCompressed((struct openb3d_ddsloader_TDDS_obj*)o)!=0){
				__glewCompressedTexImage2D(bbt_face,0,o->_openb3d_ddsloader_tdds_format [0],bbt_surf->_openb3d_ddsloader_tdds_width [0],bbt_surf->_openb3d_ddsloader_tdds_height [0],0,bbt_surf->_openb3d_ddsloader_tdds_size [0],bbt_surf->_openb3d_ddsloader_tdds_dxt );
				{
					BBINT bbt_j=0;
					BBINT bbt_=bbt_surf->_openb3d_ddsloader_tdds_mipmapcount [0];
					for(;(bbt_j<bbt_);bbt_j=(bbt_j+1)){
						struct openb3d_ddsloader_TDDS_obj* bbt_mip=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(bbt_surf->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j)];
						__glewCompressedTexImage2D(bbt_face,(bbt_j+1),o->_openb3d_ddsloader_tdds_format [0],bbt_mip->_openb3d_ddsloader_tdds_width [0],bbt_mip->_openb3d_ddsloader_tdds_height [0],0,bbt_mip->_openb3d_ddsloader_tdds_size [0],bbt_mip->_openb3d_ddsloader_tdds_dxt );
					}
				}
			}else{
				glTexImage2D((GLenum)bbt_face,(GLint)0,(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)bbt_surf->_openb3d_ddsloader_tdds_width [0],(GLsizei)bbt_surf->_openb3d_ddsloader_tdds_height [0],(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)bbt_surf->_openb3d_ddsloader_tdds_dxt );
				{
					BBINT bbt_j2=0;
					BBINT bbt_2=bbt_surf->_openb3d_ddsloader_tdds_mipmapcount [0];
					for(;(bbt_j2<bbt_2);bbt_j2=(bbt_j2+1)){
						struct openb3d_ddsloader_TDDS_obj* bbt_mip2=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj**)BBARRAYDATA(bbt_surf->_openb3d_ddsloader_tdds_mipmaps ,1))[((BBUINT)bbt_j2)];
						glTexImage2D((GLenum)bbt_face,(GLint)(bbt_j2+1),(GLint)o->_openb3d_ddsloader_tdds_components [0],(GLsizei)bbt_mip2->_openb3d_ddsloader_tdds_width [0],(GLsizei)bbt_mip2->_openb3d_ddsloader_tdds_height [0],(GLint)0,(GLenum)o->_openb3d_ddsloader_tdds_format [0],(GLenum)5121,(const GLvoid*)bbt_mip2->_openb3d_ddsloader_tdds_dxt );
					}
				}
			}
		}
	}
}
struct brl_linkedlist_TList_obj* openb3d_ddsloader_TDDS_dds_list;
struct brl_map_ptrmap_TPtrMap_obj* openb3d_ddsloader_TDDS_dds_map;
struct BBDebugScope_34 openb3d_ddsloader_TDDS_scope ={
	BBDEBUGSCOPE_USERTYPE,
	"TDDS",
	{
		{
			BBDEBUGDECL_FIELD,
			"buffer",
			"*b",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_buffer)
		},
		{
			BBDEBUGDECL_FIELD,
			"mipmaps",
			"[]:TDDS",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_mipmaps)
		},
		{
			BBDEBUGDECL_FIELD,
			"width",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_width)
		},
		{
			BBDEBUGDECL_FIELD,
			"height",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_height)
		},
		{
			BBDEBUGDECL_FIELD,
			"depth",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_depth)
		},
		{
			BBDEBUGDECL_FIELD,
			"mipmapcount",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_mipmapcount)
		},
		{
			BBDEBUGDECL_FIELD,
			"pitch",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_pitch)
		},
		{
			BBDEBUGDECL_FIELD,
			"size",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_size)
		},
		{
			BBDEBUGDECL_FIELD,
			"dxt",
			"*b",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_dxt)
		},
		{
			BBDEBUGDECL_FIELD,
			"format",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_format)
		},
		{
			BBDEBUGDECL_FIELD,
			"components",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_components)
		},
		{
			BBDEBUGDECL_FIELD,
			"target",
			"*i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_target)
		},
		{
			BBDEBUGDECL_FIELD,
			"pixmap",
			":TPixmap",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_pixmap)
		},
		{
			BBDEBUGDECL_FIELD,
			"bmx_buffer",
			"*b",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_bmx_buffer)
		},
		{
			BBDEBUGDECL_FIELD,
			"instance",
			"*b",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_instance)
		},
		{
			BBDEBUGDECL_FIELD,
			"exists",
			"i",
			.field_offset=offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_exists)
		},
		{
			BBDEBUGDECL_GLOBAL,
			"dds_list",
			":TList",
			.var_address=(void*)&openb3d_ddsloader_TDDS_dds_list
		},
		{
			BBDEBUGDECL_GLOBAL,
			"dds_map",
			":TPtrMap",
			.var_address=(void*)&openb3d_ddsloader_TDDS_dds_map
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"New",
			"()",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_New
		},
		{
			BBDEBUGDECL_TYPEFUNCTION,
			"CreateObject",
			"(*b):TDDS",
			.func_ptr=(BBFuncPtr)&openb3d_ddsloader_TDDS_CreateObject_TTDDS_pb
		},
		{
			BBDEBUGDECL_TYPEFUNCTION,
			"FreeObject",
			"(*b)",
			.func_ptr=(BBFuncPtr)&openb3d_ddsloader_TDDS_FreeObject_v_pb
		},
		{
			BBDEBUGDECL_TYPEFUNCTION,
			"GetObject",
			"(*b):TDDS",
			.func_ptr=(BBFuncPtr)&openb3d_ddsloader_TDDS_GetObject_TTDDS_pb
		},
		{
			BBDEBUGDECL_TYPEFUNCTION,
			"GetInstance",
			"(:TDDS)*b",
			.func_ptr=(BBFuncPtr)&openb3d_ddsloader_TDDS_GetInstance_pb_TTDDS
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"InitFields",
			"()",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_InitFields
		},
		{
			BBDEBUGDECL_TYPEFUNCTION,
			"StringPtr",
			"(*b)$",
			.func_ptr=(BBFuncPtr)&openb3d_ddsloader_TDDS_StringPtr_S_pb
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"DebugFields",
			"(i,i)",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_DebugFields_ii
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"FreeDDS",
			"()",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_FreeDDS
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"GetPitch",
			"(i,i,i)i",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_GetPitch_iii
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"IsCompressed",
			"()i",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_IsCompressed
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"ImageParameters",
			"(i)",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_ImageParameters_i
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"TextureParameters",
			"(i)",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_TextureParameters_i
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"UploadTexture2D",
			"(i)",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_UploadTexture2D_i
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"UploadTextureSubImage2D",
			"(i,i,i,i,*b,i,i,i)",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_UploadTextureSubImage2D_iiiipbiii
		},
		{
			BBDEBUGDECL_TYPEMETHOD,
			"UploadTextureCubeMap",
			"()",
			.func_ptr=(BBFuncPtr)&_openb3d_ddsloader_TDDS_UploadTextureCubeMap
		},
		{
			BBDEBUGDECL_END
		}
	}
};
struct BBClass_openb3d_ddsloader_TDDS openb3d_ddsloader_TDDS={
	&bbObjectClass,
	bbObjectFree,
	(BBDebugScope*)&openb3d_ddsloader_TDDS_scope,
	sizeof(struct openb3d_ddsloader_TDDS_obj),
	(void (*)(BBOBJECT))_openb3d_ddsloader_TDDS_New,
	bbObjectDtor,
	bbObjectToString,
	bbObjectCompare,
	bbObjectSendMessage,
	0,
	0,
	offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_exists) - offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_buffer) + sizeof(BBINT)
	,0
	,offsetof(struct openb3d_ddsloader_TDDS_obj,_openb3d_ddsloader_tdds_buffer)
	,openb3d_ddsloader_TDDS_CreateObject_TTDDS_pb
	,openb3d_ddsloader_TDDS_FreeObject_v_pb
	,openb3d_ddsloader_TDDS_GetObject_TTDDS_pb
	,openb3d_ddsloader_TDDS_GetInstance_pb_TTDDS
	,_openb3d_ddsloader_TDDS_InitFields
	,openb3d_ddsloader_TDDS_StringPtr_S_pb
	,_openb3d_ddsloader_TDDS_DebugFields_ii
	,_openb3d_ddsloader_TDDS_FreeDDS
	,_openb3d_ddsloader_TDDS_GetPitch_iii
	,_openb3d_ddsloader_TDDS_IsCompressed
	,_openb3d_ddsloader_TDDS_ImageParameters_i
	,_openb3d_ddsloader_TDDS_TextureParameters_i
	,_openb3d_ddsloader_TDDS_UploadTexture2D_i
	,_openb3d_ddsloader_TDDS_UploadTextureSubImage2D_iiiipbiii
	,_openb3d_ddsloader_TDDS_UploadTextureCubeMap
};

struct brl_max2d_image_TImage_obj* openb3d_ddsloader_LoadImageDDS(BBOBJECT bbt_url,BBINT bbt_flags,BBINT bbt_mr,BBINT bbt_mg,BBINT bbt_mb){
	struct brl_pixmap_TPixmap_obj* bbt_pixmap=(struct brl_pixmap_TPixmap_obj*)brl_pixmap_LoadPixmap((BBOBJECT)bbt_url);
	struct openb3d_ddsloader_TDDS_obj* bbt_dds=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj*)bbObjectDowncast((BBOBJECT)(openb3d_ddsloader_TDDS_dds_list)->clas->m_Last((struct brl_linkedlist_TList_obj*)openb3d_ddsloader_TDDS_dds_list),(BBClass*)&openb3d_ddsloader_TDDS));
	if(((BBOBJECT)bbt_dds->_openb3d_ddsloader_tdds_pixmap )==&bbNullObject){
		brl_blitz_DebugLog(bbStringConcat(((BBString*)&_s0),((BBString *)bbObjectStringcast((BBOBJECT)bbt_url))));
		return (struct brl_max2d_image_TImage_obj*)&bbNullObject;
	}
	if(((BBINT*)BBARRAYDATA(brl_pixmap_pixel_RedBitsPerPixel,1))[0U]==0){
		brl_blitz_DebugLog((BBString*)&_s1);
	}
	struct brl_max2d_image_TImage_obj* bbt_img=(struct brl_max2d_image_TImage_obj*)brl_max2d_image_TImage_Create_TTImage_iiiiiii(bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_width ,bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_height ,1,bbt_flags,bbt_mr,bbt_mg,bbt_mb);
	BBINT bbt_pix_format=bbt_dds->_openb3d_ddsloader_tdds_format [0];
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33776){
		bbt_pix_format=6407;
	}
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33778){
		bbt_pix_format=6408;
	}
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33779){
		bbt_pix_format=6408;
	}
	BBINT bbt_name=0;
	glGenTextures((GLsizei)1,(GLuint*)(&bbt_name));
	glBindTexture((GLenum)3553,(GLuint)bbt_name);
	(bbt_dds)->clas->m_ImageParameters_i((struct openb3d_ddsloader_TDDS_obj*)bbt_dds,bbt_flags);
	(bbt_dds)->clas->m_UploadTexture2D_i((struct openb3d_ddsloader_TDDS_obj*)bbt_dds,((unsigned int)(bbt_flags)&(unsigned int)(4)));
	if(((BBINT*)BBARRAYDATA(brl_pixmap_pixel_RedBitsPerPixel,1))[0U]==0){
		glGetTexImage((GLenum)3553,(GLint)0,(GLenum)bbt_pix_format,(GLenum)5121,(GLvoid*)bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_pixels );
		glDeleteTextures((GLsizei)1,(const GLuint*)(&bbt_name));
	}else{
		((BBINT*)BBARRAYDATA(brl_pixmap_pixel_GreenBitsPerPixel,1))[0U]=bbt_dds->_openb3d_ddsloader_tdds_format [0];
		((BBINT*)BBARRAYDATA(brl_pixmap_pixel_BlueBitsPerPixel,1))[0U]=bbt_name;
	}
	(bbt_img)->clas->m_SetPixmap_iTTPixmapi((struct brl_max2d_image_TImage_obj*)bbt_img,0,(struct brl_pixmap_TPixmap_obj*)bbt_dds->_openb3d_ddsloader_tdds_pixmap ,0);
	(bbt_dds)->clas->m_FreeDDS((struct openb3d_ddsloader_TDDS_obj*)bbt_dds);
	return (struct brl_max2d_image_TImage_obj*)bbt_img;
}
struct brl_max2d_image_TImage_obj* openb3d_ddsloader_LoadAnimImageDDS(BBOBJECT bbt_url,BBINT bbt_cell_width,BBINT bbt_cell_height,BBINT bbt_first_cell,BBINT bbt_cell_count,BBINT bbt_flags,BBINT bbt_mr,BBINT bbt_mg,BBINT bbt_mb){
	struct brl_pixmap_TPixmap_obj* bbt_pixmap=(struct brl_pixmap_TPixmap_obj*)brl_pixmap_LoadPixmap((BBOBJECT)bbt_url);
	struct openb3d_ddsloader_TDDS_obj* bbt_dds=(struct openb3d_ddsloader_TDDS_obj*)((struct openb3d_ddsloader_TDDS_obj*)bbObjectDowncast((BBOBJECT)(openb3d_ddsloader_TDDS_dds_list)->clas->m_Last((struct brl_linkedlist_TList_obj*)openb3d_ddsloader_TDDS_dds_list),(BBClass*)&openb3d_ddsloader_TDDS));
	if(((BBOBJECT)bbt_dds->_openb3d_ddsloader_tdds_pixmap )==&bbNullObject){
		brl_blitz_DebugLog(bbStringConcat(((BBString*)&_s0),((BBString *)bbObjectStringcast((BBOBJECT)bbt_url))));
		return (struct brl_max2d_image_TImage_obj*)&bbNullObject;
	}
	if(((BBINT*)BBARRAYDATA(brl_pixmap_pixel_RedBitsPerPixel,1))[0U]==0){
		brl_blitz_DebugLog((BBString*)&_s1);
	}
	BBINT bbt_x_cells=(bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_width /bbt_cell_width);
	BBINT bbt_y_cells=(bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_height /bbt_cell_height);
	if((bbt_first_cell+bbt_cell_count)>(bbt_x_cells*bbt_y_cells)){
		return (struct brl_max2d_image_TImage_obj*)&bbNullObject;
	}
	struct brl_max2d_image_TImage_obj* bbt_img=(struct brl_max2d_image_TImage_obj*)brl_max2d_image_TImage_Create_TTImage_iiiiiii(bbt_cell_width,bbt_cell_height,bbt_cell_count,bbt_flags,bbt_mr,bbt_mg,bbt_mb);
	BBINT bbt_pix_format=bbt_dds->_openb3d_ddsloader_tdds_format [0];
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33776){
		bbt_pix_format=6407;
	}
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33778){
		bbt_pix_format=6408;
	}
	if(bbt_dds->_openb3d_ddsloader_tdds_format [0]==33779){
		bbt_pix_format=6408;
	}
	BBINT bbt_name=0;
	{
		BBINT bbt_cell=bbt_first_cell;
		BBINT bbt_=((bbt_first_cell+bbt_cell_count)-1);
		for(;(bbt_cell<=bbt_);bbt_cell=(bbt_cell+1)){
			BBINT bbt_x=((bbt_cell % bbt_x_cells)*bbt_cell_width);
			BBINT bbt_y=((bbt_cell/bbt_x_cells)*bbt_cell_height);
			struct brl_pixmap_TPixmap_obj* bbt_animmap=(struct brl_pixmap_TPixmap_obj*)brl_pixmap_CreatePixmap(bbt_cell_width,bbt_cell_height,bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_format ,((BBINT*)BBARRAYDATA(brl_pixmap_pixel_BytesPerPixel,1))[((BBUINT)bbt_dds->_openb3d_ddsloader_tdds_pixmap ->_brl_pixmap_tpixmap_format )]);
			glGenTextures((GLsizei)1,(GLuint*)(&bbt_name));
			glBindTexture((GLenum)3553,(GLuint)bbt_name);
			(bbt_dds)->clas->m_ImageParameters_i((struct openb3d_ddsloader_TDDS_obj*)bbt_dds,bbt_flags);
			(bbt_dds)->clas->m_UploadTextureSubImage2D_iiiipbiii((struct openb3d_ddsloader_TDDS_obj*)bbt_dds,bbt_x,bbt_y,bbt_cell_width,bbt_cell_height,bbt_animmap->_brl_pixmap_tpixmap_pixels ,((unsigned int)(bbt_flags)&(unsigned int)(4)),3553,0);
			if(((BBINT*)BBARRAYDATA(brl_pixmap_pixel_RedBitsPerPixel,1))[0U]==0){
				glGetTexImage((GLenum)3553,(GLint)0,(GLenum)bbt_pix_format,(GLenum)5121,(GLvoid*)bbt_animmap->_brl_pixmap_tpixmap_pixels );
				glDeleteTextures((GLsizei)1,(const GLuint*)(&bbt_name));
			}else{
				DDSCopyRect_(bbt_dds->_openb3d_ddsloader_tdds_dxt ,bbt_dds->_openb3d_ddsloader_tdds_width [0],bbt_dds->_openb3d_ddsloader_tdds_height [0],bbt_x,bbt_y,bbt_animmap->_brl_pixmap_tpixmap_pixels ,bbt_cell_width,bbt_cell_height,bbt_dds->_openb3d_ddsloader_tdds_components [0],0,bbt_dds->_openb3d_ddsloader_tdds_format [0]);
				((BBINT*)BBARRAYDATA(brl_pixmap_pixel_GreenBitsPerPixel,1))[0U]=bbt_dds->_openb3d_ddsloader_tdds_format [0];
				((BBINT*)BBARRAYDATA(brl_pixmap_pixel_BlueBitsPerPixel,1))[0U]=bbt_name;
			}
			(bbt_img)->clas->m_SetPixmap_iTTPixmapi((struct brl_max2d_image_TImage_obj*)bbt_img,(bbt_cell-bbt_first_cell),(struct brl_pixmap_TPixmap_obj*)bbt_animmap,0);
		}
	}
	(bbt_dds)->clas->m_FreeDDS((struct openb3d_ddsloader_TDDS_obj*)bbt_dds);
	return (struct brl_max2d_image_TImage_obj*)bbt_img;
}
static int __bb_openb3d_ddsloader_ddsloader_inited = 0;
int __bb_openb3d_ddsloader_ddsloader(){
	if (!__bb_openb3d_ddsloader_ddsloader_inited) {
		__bb_openb3d_ddsloader_ddsloader_inited = 1;
		GC_add_roots(&openb3d_ddsloader_TDDS_dds_list, &openb3d_ddsloader_TDDS_dds_map + 1);
		__bb_brl_blitz_blitz();
		__bb_pub_glew_glew();
		__bb_pub_opengl_opengl();
		__bb_brl_glmax2d_glmax2d();
		__bb_brl_ramstream_ramstream();
		__bb_brl_retro_retro();
		__bb_brl_map_map();
		_bb_openb3d_ddsloader_source();
		bbObjectRegisterType((BBCLASS)&openb3d_ddsloader_TPixmapLoaderDDS);
		bbObjectRegisterType((BBCLASS)&openb3d_ddsloader_TDDS);
		openb3d_ddsloader_TDDS_dds_list=((struct brl_linkedlist_TList_obj*)&bbNullObject);
		openb3d_ddsloader_TDDS_dds_map=((struct brl_map_ptrmap_TPtrMap_obj*)&bbNullObject);
		openb3d_ddsloader_TDDS_dds_list=(struct brl_linkedlist_TList_obj*)brl_linkedlist_CreateList();
		openb3d_ddsloader_TDDS_dds_map=(struct brl_map_ptrmap_TPtrMap_obj*)(struct brl_map_ptrmap_TPtrMap_obj*)bbObjectAtomicNew((BBClass *)&brl_map_ptrmap_TPtrMap);
		(struct openb3d_ddsloader_TPixmapLoaderDDS_obj*)bbObjectNew((BBClass *)&openb3d_ddsloader_TPixmapLoaderDDS);
		return 0;
	}
	return 0;
}